/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeExceptionWrappingDatastoreService
implements DatastoreService {
    private final DatastoreService inner;

    public RuntimeExceptionWrappingDatastoreService(DatastoreService inner) {
        this.inner = inner;
    }

    public Entity get(Key key) throws EntityNotFoundException {
        try {
            return this.inner.get(key);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Entity get(Transaction transaction, Key key) throws EntityNotFoundException {
        try {
            return this.inner.get(transaction, key);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Map<Key, Entity> get(Iterable<Key> keyIterable) {
        try {
            return this.inner.get(keyIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Map<Key, Entity> get(Transaction transaction, Iterable<Key> keyIterable) {
        try {
            return this.inner.get(transaction, keyIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Key put(Entity entity) {
        try {
            return this.inner.put(entity);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Key put(Transaction transaction, Entity entity) {
        try {
            return this.inner.put(transaction, entity);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public List<Key> put(Iterable<Entity> entityIterable) {
        try {
            return this.inner.put(entityIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public List<Key> put(Transaction transaction, Iterable<Entity> entityIterable) {
        try {
            return this.inner.put(transaction, entityIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public void delete(Key ... keys) {
        try {
            this.inner.delete(keys);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public void delete(Transaction transaction, Key ... keys) {
        try {
            this.inner.delete(transaction, keys);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public void delete(Iterable<Key> keyIterable) {
        try {
            this.inner.delete(keyIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public void delete(Transaction transaction, Iterable<Key> keyIterable) {
        try {
            this.inner.delete(transaction, keyIterable);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            throw DatastoreExceptionTranslator.wrapConcurrentModificationException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public PreparedQuery prepare(Query query) {
        try {
            return this.inner.prepare(query);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public PreparedQuery prepare(Transaction transaction, Query query) {
        try {
            return this.inner.prepare(transaction, query);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Transaction beginTransaction() {
        try {
            return this.inner.beginTransaction();
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Transaction getCurrentTransaction() {
        try {
            return this.inner.getCurrentTransaction();
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Transaction getCurrentTransaction(Transaction transaction) {
        try {
            return this.inner.getCurrentTransaction(transaction);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Collection<Transaction> getActiveTransactions() {
        try {
            return this.inner.getActiveTransactions();
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public KeyRange allocateIds(String kind, long num) {
        try {
            return this.inner.allocateIds(kind, num);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public KeyRange allocateIds(Key parent, String kind, long num) {
        try {
            return this.inner.allocateIds(parent, kind, num);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }
}

