/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValidatedQuery {
    private static final Comparator<OnestoreEntity.Index.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Index.Property>(){

        @Override
        public int compare(OnestoreEntity.Index.Property o1, OnestoreEntity.Index.Property o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final DatastorePb.Query query;
    private final Set<String> equalityProps = Sets.newHashSet();
    private final List<OnestoreEntity.Index.Property> indexProps = Lists.newArrayList();

    ValidatedQuery(DatastorePb.Query query) {
        this.query = query;
        this.categorizeAndValidate();
    }

    DatastorePb.Query getQuery() {
        return this.query;
    }

    Set<String> getEqualityProps() {
        return this.equalityProps;
    }

    List<OnestoreEntity.Index.Property> getIndexProps() {
        return this.indexProps;
    }

    private void categorizeAndValidate() {
        if (!this.query.hasKind() && !this.query.hasAncestor()) {
            throw new IllegalQueryException("Either kind or ancestor or both must be specified.", IllegalQueryType.NO_KIND_OR_ANCESTOR);
        }
        if (!(this.query.hasKind() || this.query.filterSize() <= 0 && this.query.orderSize() <= 0)) {
            throw new IllegalQueryException("Filters and sort orders require a kind.", IllegalQueryType.FILTERS_AND_SORTS_REQUIRE_KIND);
        }
        List filters = this.query.filters();
        String ineqProp = null;
        HashSet existsProps = Sets.newHashSet();
        block5: for (DatastorePb.Query.Filter filter : filters) {
            int numProps = filter.propertySize();
            if (numProps != 1) {
                throw new IllegalQueryException(String.format("Filter has %s properties, expected 1", numProps), IllegalQueryType.FILTER_WITH_MULTIPLE_PROPS);
            }
            String propName = filter.getProperty(0).getName();
            switch (filter.getOpEnum()) {
                case EQUAL: {
                    this.equalityProps.add(propName);
                    continue block5;
                }
                case EXISTS: {
                    existsProps.add(propName);
                    continue block5;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    if (ineqProp == null) {
                        ineqProp = propName;
                        continue block5;
                    }
                    if (ineqProp.equals(propName)) continue block5;
                    throw new IllegalQueryException(String.format("Only one inequality filter per query is supported.  Encountered both %s and %s", ineqProp, propName), IllegalQueryType.MULTIPLE_INEQ_FILTERS);
                }
            }
            throw new IllegalQueryException(String.format("Unsupported filter operator: %s", filter.getOp()), IllegalQueryType.UNSUPPORTED_FILTER);
        }
        List orders = this.query.orders();
        ArrayList newOrders = Lists.newArrayList();
        for (DatastorePb.Query.Order order : orders) {
            if (this.equalityProps.contains(order.getProperty())) continue;
            newOrders.add(order);
        }
        orders = newOrders;
        for (String eqProp : this.equalityProps) {
            this.indexProps.add(ValidatedQuery.newIndexProperty(eqProp, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
        Collections.sort(this.indexProps, PROPERTY_NAME_COMPARATOR);
        if (ineqProp != null) {
            if (orders.isEmpty()) {
                this.indexProps.add(ValidatedQuery.newIndexProperty(ineqProp, OnestoreEntity.Index.Property.Direction.ASCENDING));
            } else if (!ineqProp.equals(((DatastorePb.Query.Order)orders.get(0)).getProperty())) {
                throw new IllegalQueryException(String.format("The first sort property must be the same as the property to which the inequality filter is applied.  In your query the first sort property is %s but the inequality filter is on %s", ((DatastorePb.Query.Order)orders.get(0)).getProperty(), ineqProp), IllegalQueryType.FIRST_SORT_NEQ_INEQ_PROP);
            }
        }
        for (DatastorePb.Query.Order order : orders) {
            this.indexProps.add(ValidatedQuery.newIndexProperty(order.getProperty(), OnestoreEntity.Index.Property.Direction.valueOf((int)order.getDirection())));
        }
        for (String existsProp : existsProps) {
            if (ValidatedQuery.indexPropertyWithNameExists(existsProp, this.indexProps)) continue;
            this.indexProps.add(ValidatedQuery.newIndexProperty(existsProp, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
    }

    private static boolean indexPropertyWithNameExists(String propName, List<OnestoreEntity.Index.Property> indexProperties) {
        for (OnestoreEntity.Index.Property indexProperty : indexProperties) {
            if (!indexProperty.getName().equals(propName)) continue;
            return true;
        }
        return false;
    }

    private static OnestoreEntity.Index.Property newIndexProperty(String name, OnestoreEntity.Index.Property.Direction direction) {
        OnestoreEntity.Index.Property indexProperty = new OnestoreEntity.Index.Property();
        indexProperty.setName(name);
        indexProperty.setDirection(direction);
        return indexProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedQuery that = (ValidatedQuery)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    static class IllegalQueryException
    extends ApiProxy.ApplicationException {
        private final IllegalQueryType illegalQueryType;

        IllegalQueryException(String errorDetail, IllegalQueryType illegalQueryType) {
            super(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), errorDetail);
            this.illegalQueryType = illegalQueryType;
        }

        IllegalQueryType getIllegalQueryType() {
            return this.illegalQueryType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IllegalQueryType {
        NO_KIND_OR_ANCESTOR,
        FILTERS_AND_SORTS_REQUIRE_KIND,
        UNSUPPORTED_FILTER,
        FILTER_WITH_MULTIPLE_PROPS,
        MULTIPLE_INEQ_FILTERS,
        FIRST_SORT_NEQ_INEQ_PROP;

    }
}

