/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache.dev;

import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.dev.LRU;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalMemcacheService
implements LocalRpcService {
    public static final String SIZE_PROPERTY = "memcache.maxsize";
    private static final String DEFAULT_MAX_SIZE = "100M";
    private static final String PACKAGE = "memcache";
    private static final String UTF8 = "UTF-8";
    private LRU<CacheEntry> lru = new LRU();
    private final Map<String, Map<Key, CacheEntry>> mockCache = new HashMap<String, Map<Key, CacheEntry>>();
    private final Map<String, Map<Key, Long>> deleteHold = new HashMap<String, Map<Key, Long>>();
    private long maxSize;
    private LocalStats stats = new LocalStats(0L, 0L, 0L, 0L, 0L);

    private <K1, K2, V> Map<K2, V> getOrMakeSubMap(Map<K1, Map<K2, V>> map, K1 key) {
        Map<K2, V> subMap = map.get(key);
        if (subMap == null) {
            subMap = new HashMap<K2, V>();
            map.put(key, subMap);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getWithExpiration(String namespace, Key key) {
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            CacheEntry entry = this.getOrMakeSubMap(this.mockCache, namespace).get(key);
            if (entry != null) {
                if (entry.expires == 0L || System.currentTimeMillis() < entry.expires) {
                    entry.access = System.currentTimeMillis();
                    this.lru.update(entry);
                    return entry;
                }
                this.getOrMakeSubMap(this.mockCache, namespace).remove(key);
                this.lru.remove(entry);
                this.stats.recordDelete(entry);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry internalDelete(String namespace, Key key) {
        CacheEntry ce;
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            ce = this.getOrMakeSubMap(this.mockCache, namespace).remove(key);
            if (ce != null) {
                this.lru.remove(ce);
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSet(String namespace, Key key, CacheEntry entry) {
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            Map<Key, CacheEntry> namespaceMap = this.getOrMakeSubMap(this.mockCache, namespace);
            CacheEntry old = namespaceMap.get(key);
            if (old != null) {
                this.stats.recordDelete(old);
            }
            namespaceMap.put(key, entry);
            this.lru.update(entry);
            this.stats.recordAdd(entry);
        }
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String propValue = properties.get(SIZE_PROPERTY);
        propValue = propValue == null ? DEFAULT_MAX_SIZE : propValue.toUpperCase();
        int multiplier = 1;
        if (propValue.endsWith("M") || propValue.endsWith("K")) {
            multiplier = propValue.endsWith("M") ? 0x100000 : 1024;
            propValue = propValue.substring(0, propValue.length() - 1);
        }
        try {
            this.maxSize = Long.parseLong(propValue) * (long)multiplier;
        }
        catch (NumberFormatException ex) {
            throw new MemcacheServiceException("Can't parse cache size limit '" + properties.get(SIZE_PROPERTY) + "'", (Throwable)ex);
        }
    }

    public void setLimits(int bytes) {
        this.maxSize = bytes;
    }

    public void start() {
    }

    public void stop() {
    }

    public MemcacheServicePb.MemcacheGetResponse get(LocalRpcService.Status status, MemcacheServicePb.MemcacheGetRequest req) {
        MemcacheServicePb.MemcacheGetResponse result = new MemcacheServicePb.MemcacheGetResponse();
        for (int i = 0; i < req.keySize(); ++i) {
            Key key = new Key(req.getKeyAsBytes(i));
            CacheEntry entry = this.getWithExpiration(req.getNameSpace(), key);
            if (entry == null) {
                this.stats.recordMiss();
                continue;
            }
            this.stats.recordHit(entry);
            result.addItem(new MemcacheServicePb.MemcacheGetResponse.Item().setKeyAsBytes(key.getBytes()).setFlags(entry.flags).setValueAsBytes(entry.value));
        }
        status.setSuccessful(true);
        return result;
    }

    public MemcacheServicePb.MemcacheSetResponse set(LocalRpcService.Status status, MemcacheServicePb.MemcacheSetRequest req) {
        MemcacheServicePb.MemcacheSetResponse result = new MemcacheServicePb.MemcacheSetResponse();
        String namespace = req.getNameSpace();
        for (int i = 0; i < req.itemSize(); ++i) {
            Long timeout;
            MemcacheServicePb.MemcacheSetRequest.Item item = req.getItem(i);
            Key key = new Key(item.getKeyAsBytes());
            MemcacheServicePb.MemcacheSetRequest.SetPolicy policy = item.getSetPolicyEnum();
            if (policy != MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET && (timeout = this.getOrMakeSubMap(this.deleteHold, namespace).get(key)) != null && System.currentTimeMillis() < timeout) {
                result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.NOT_STORED.getValue());
                continue;
            }
            CacheEntry entry = this.getWithExpiration(namespace, key);
            if (entry == null && policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.REPLACE || entry != null && policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.ADD) {
                result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.NOT_STORED.getValue());
                continue;
            }
            long expiry = item.hasExpirationTime() ? (long)item.getExpirationTime() : 0L;
            byte[] value = item.getValueAsBytes();
            int flags = item.getFlags();
            CacheEntry ce = new CacheEntry(namespace, key, value, flags, expiry * 1000L);
            this.internalSet(namespace, key, ce);
            result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED.getValue());
        }
        status.setSuccessful(true);
        return result;
    }

    public MemcacheServicePb.MemcacheDeleteResponse delete(LocalRpcService.Status status, MemcacheServicePb.MemcacheDeleteRequest req) {
        MemcacheServicePb.MemcacheDeleteResponse result = new MemcacheServicePb.MemcacheDeleteResponse();
        String namespace = req.getNameSpace();
        for (int i = 0; i < req.itemSize(); ++i) {
            MemcacheServicePb.MemcacheDeleteRequest.Item item = req.getItem(i);
            Key key = new Key(item.getKeyAsBytes());
            CacheEntry ce = this.internalDelete(namespace, key);
            result.addDeleteStatus(ce == null ? MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.NOT_FOUND.getValue() : MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED.getValue());
            if (ce != null) {
                this.stats.recordDelete(ce);
            }
            if (!item.hasDeleteTime()) continue;
            int millisNoReAdd = item.getDeleteTime() * 1000;
            this.getOrMakeSubMap(this.deleteHold, namespace).put(key, System.currentTimeMillis() + (long)millisNoReAdd);
        }
        status.setSuccessful(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheIncrementResponse increment(LocalRpcService.Status status, MemcacheServicePb.MemcacheIncrementRequest req) {
        MemcacheServicePb.MemcacheIncrementResponse result = new MemcacheServicePb.MemcacheIncrementResponse();
        String namespace = req.getNameSpace();
        Key key = new Key(req.getKeyAsBytes());
        long delta = req.getDelta();
        if (req.getDirectionEnum() == MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT) {
            delta = -delta;
        }
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            Long longval;
            CacheEntry ce = this.getWithExpiration(namespace, key);
            if (ce == null) {
                this.stats.recordMiss();
                return result;
            }
            this.stats.recordHit(ce);
            try {
                longval = Long.parseLong(new String(ce.value, UTF8));
            }
            catch (NumberFormatException e) {
                status.setSuccessful(false);
                throw new ApiProxy.ApplicationException(1, "Format error");
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiProxy.UnknownException("UTF-8 encoding was not found.");
            }
            long newvalue = longval;
            newvalue += delta;
            this.stats.recordDelete(ce);
            try {
                ce.value = Long.toString(newvalue).getBytes(UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiProxy.UnknownException("UTF-8 encoding was not found.");
            }
            ce.bytes = key.getBytes().length + ce.value.length;
            Map<Key, CacheEntry> namespaceMap = this.getOrMakeSubMap(this.mockCache, namespace);
            namespaceMap.remove(key);
            namespaceMap.put(key, ce);
            this.stats.recordAdd(ce);
            result.setNewValue(newvalue);
        }
        status.setSuccessful(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheFlushResponse flushAll(LocalRpcService.Status status, MemcacheServicePb.MemcacheFlushRequest req) {
        MemcacheServicePb.MemcacheFlushResponse result = new MemcacheServicePb.MemcacheFlushResponse();
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            this.mockCache.clear();
            this.deleteHold.clear();
            this.lru.clear();
            this.stats = new LocalStats(0L, 0L, 0L, 0L, 0L);
        }
        status.setSuccessful(true);
        return result;
    }

    public MemcacheServicePb.MemcacheStatsResponse stats(LocalRpcService.Status status, MemcacheServicePb.MemcacheStatsRequest req) {
        MemcacheServicePb.MemcacheStatsResponse result = new MemcacheServicePb.MemcacheStatsResponse();
        result.setStats(this.stats.getAsMergedNamespaceStats());
        status.setSuccessful(true);
        return result;
    }

    private class Key {
        private byte[] keyval;

        public Key(byte[] bytes) {
            this.keyval = bytes;
        }

        public byte[] getBytes() {
            return this.keyval;
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                return Arrays.equals(this.keyval, ((Key)other).keyval);
            }
            if (other instanceof byte[]) {
                return Arrays.equals(this.keyval, (byte[])other);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.keyval);
        }
    }

    private class LocalStats {
        private long hits;
        private long misses;
        private long hitBytes;
        private long itemCount;
        private long totalBytes;

        private LocalStats(long hits, long misses, long hitBytes, long itemCount, long totalBytes) {
            this.hits = hits;
            this.misses = misses;
            this.hitBytes = hitBytes;
            this.itemCount = itemCount;
            this.totalBytes = totalBytes;
        }

        public MemcacheServicePb.MergedNamespaceStats getAsMergedNamespaceStats() {
            MemcacheServicePb.MergedNamespaceStats mns = new MemcacheServicePb.MergedNamespaceStats();
            mns.setHits(this.hits);
            mns.setMisses(this.misses);
            mns.setByteHits(this.hitBytes);
            mns.setBytes(this.totalBytes);
            mns.setItems(this.itemCount);
            mns.setOldestItemAge(this.getMaxSecondsWithoutAccess());
            return mns;
        }

        public int getMaxSecondsWithoutAccess() {
            if (LocalMemcacheService.this.lru.isEmpty()) {
                return 0;
            }
            CacheEntry entry = (CacheEntry)LocalMemcacheService.this.lru.getOldest();
            return (int)((System.currentTimeMillis() - entry.access) / 1000L);
        }

        public void recordHit(CacheEntry ce) {
            ++this.hits;
            this.hitBytes += ce.bytes;
        }

        public void recordMiss() {
            ++this.misses;
        }

        public void recordAdd(CacheEntry ce) {
            ++this.itemCount;
            this.totalBytes += ce.bytes;
            while (this.totalBytes > LocalMemcacheService.this.maxSize) {
                CacheEntry oldest = (CacheEntry)LocalMemcacheService.this.lru.getOldest();
                LocalMemcacheService.this.internalDelete(oldest.namespace, oldest.key);
                --this.itemCount;
                this.totalBytes -= oldest.bytes;
            }
        }

        public void recordDelete(CacheEntry ce) {
            --this.itemCount;
            this.totalBytes -= ce.bytes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheEntry
    extends LRU.AbstractChainable<CacheEntry> {
        public String namespace;
        public Key key;
        public byte[] value;
        int flags;
        public long expires;
        public long access;
        public long bytes;

        public CacheEntry(String namespace, Key key, byte[] value, int flags, long expiration) throws IllegalArgumentException {
            this.namespace = namespace;
            this.key = key;
            this.value = value;
            this.flags = flags;
            this.expires = expiration;
            this.access = System.currentTimeMillis();
            this.bytes = key.getBytes().length + value.length;
        }
    }
}

