package com.shin1ogawa.entity;

import java.io.Serializable;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.google.appengine.api.datastore.Key;

@SuppressWarnings("serial")
@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class ChildBChild implements Serializable {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Key key;

	@Persistent(mappedBy = "children")
	private ChildB ancestor;

	@Persistent
	private String value;

	public Key getKey() {
		return key;
	}

	public void setKey(Key key) {
		this.key = key;
	}

	/**
	 * @return the ancestor
	 */
	public ChildB getAncestor() {
		return ancestor;
	}

	/**
	 * @param ancestor
	 *            the ancestor to set
	 */
	public void setAncestor(ChildB ancestor) {
		this.ancestor = ancestor;
	}

	public String getValue() {
		return value;
	}

	public ChildBChild setValue(String value) {
		this.value = value;
		return this;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
