package com.shin1ogawa;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;

/**
 * @author shin1ogawa
 */
public class JdoModule extends AbstractModule {

	@Override
	protected void configure() {
		bind(PersistenceManager.class).toProvider(new Provider<PersistenceManager>() {

			public PersistenceManager get() {
				PersistenceManager persistenceManager =
						JDOHelper.getPersistenceManagerFactory("transactions-optional")
							.getPersistenceManager();
				return persistenceManager;
			}
		}).in(Singleton.class);
	}
}
