/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: OutputEventQueueManager.java,v 1.3 2009/01/28 13:51:17 nishimoto Exp $
 */
package galatea.io;

import galatea.logger.Logger;

import java.util.*;

public class OutputEventQueueManager            
{
	private Logger dbg = new Logger(this.getClass());
	
	private ArrayList<DeviceEvent> queue_; // ArrayList<DeviceEvent>
	
	public OutputEventQueueManager()
	{
		queue_ = new ArrayList<DeviceEvent>();
	}
	
	public synchronized void discard()
	{
		queue_.clear();
	}
	
	public synchronized void enqueue(DeviceEvent o)
	{
		queue_.add(o);
		dbg.print("EQM: added " + o.getClass().getName() 
				+ ", total:" + queue_.size() );
	}
	
	public synchronized DeviceEvent dequeue()  
	{
		DeviceEvent ret;
		
		if (queue_.isEmpty()) {
			return null;
		} else {
			ret = (DeviceEvent)queue_.remove(0);
			dbg.print("EQM: removed " + ret.getClass().getName() 
					+ ", total:" + queue_.size() );
			return ret;
		}
	}
	
}
