/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventINPUT</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="INPUT">
 *       <attribute name="STATUS">
 *         <data type="token"/>
 *       </attribute>
 *       <attribute name="TIME">
 *         <data type="int"/>
 *       </attribute>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="INPUT"&gt;
 *       &lt;attribute name="STATUS"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="TIME"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Thu Oct 02 00:02:10 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventINPUT implements java.io.Serializable, Cloneable, IEventEvChoice {
    private String STATUS_;
    private int TIME_;
    private Element xmlElement;

    /**
     * Creates a <code>EventINPUT</code>.
     *
     */
    public EventINPUT() {
        STATUS_ = "";
    }

    /**
     * Creates a <code>EventINPUT</code>.
     *
     * @param source
     */
    public EventINPUT(EventINPUT source) {
        setup(source);
    }

    /**
     * Creates a <code>EventINPUT</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventINPUT(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventINPUT</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventINPUT(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventINPUT</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventINPUT(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventINPUT</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventINPUT</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventINPUT</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventINPUT</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventINPUT</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventINPUT</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUT(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventINPUT</code> by the EventINPUT <code>source</code>.
     *
     * @param source
     */
    public void setup(EventINPUT source) {
        int size;
        STATUS_ = source.STATUS_;
        TIME_ = source.TIME_;
    }

    /**
     * Initializes the <code>EventINPUT</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventINPUT</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventINPUT</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        STATUS_ = URelaxer.getAttributePropertyAsString(element, "STATUS");
        TIME_ = URelaxer.getAttributePropertyAsInt(element, "TIME");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventINPUT((EventINPUT)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("INPUT");
        int size;
        if (this.STATUS_ != null) {
            URelaxer.setAttributePropertyByString(element, "STATUS", this.STATUS_);
        }
        URelaxer.setAttributePropertyByInt(element, "TIME", this.TIME_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventINPUT</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventINPUT</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUT</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUT</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUT</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUT</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>STATUS</b>.
     *
     * @return String
     */
    public String getSTATUS() {
        return (STATUS_);
    }

    /**
     * Sets the String property <b>STATUS</b>.
     *
     * @param STATUS
     */
    public void setSTATUS(String STATUS) {
        this.STATUS_ = STATUS;
    }

    /**
     * Gets the int property <b>TIME</b>.
     *
     * @return int
     */
    public int getTIME() {
        return (TIME_);
    }

    /**
     * Sets the int property <b>TIME</b>.
     *
     * @param TIME
     */
    public void setTIME(int TIME) {
        this.TIME_ = TIME;
    }

    /**
     * Gets the int property <b>TIME</b>.
     *
     * @return Integer
     */
    public Integer getTIMEAsInteger() {
        return (new Integer(TIME_));
    }

    /**
     * Sets the int property <b>TIME</b>.
     *
     * @param TIME
     */
    public void setTIME(Integer TIME) {
        this.TIME_ = TIME.intValue();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<INPUT");
        if (STATUS_ != null) {
            buffer.append(" STATUS=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSTATUS())));
            buffer.append("\"");
        }
        buffer.append(" TIME=\"");
        buffer.append(URelaxer.getString(getTIME()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</INPUT>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<INPUT");
        if (STATUS_ != null) {
            buffer.write(" STATUS=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSTATUS())));
            buffer.write("\"");
        }
        buffer.write(" TIME=\"");
        buffer.write(URelaxer.getString(getTIME()));
        buffer.write("\"");
        buffer.write(">");
        buffer.write("</INPUT>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<INPUT");
        if (STATUS_ != null) {
            buffer.print(" STATUS=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSTATUS())));
            buffer.print("\"");
        }
        buffer.print(" TIME=\"");
        buffer.print(URelaxer.getString(getTIME()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</INPUT>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSTATUSAsString() {
        return (URelaxer.getString(getSTATUS()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTIMEAsString() {
        return (URelaxer.getString(getTIME()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSTATUSByString(String string) {
        setSTATUS(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTIMEByString(String string) {
        setTIME(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventINPUT</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "INPUT")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "STATUS")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "TIME")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventINPUT</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventINPUT</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
