/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: StringHashArray.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.util;

//import galatea.main.Debug;
//import java.util.*;

public class StringHashArray extends HashArray
{
	public StringHashArray()
	{
		super();
	}
	
	public String put(String key, String value)
	{
		return (String)put(key, (Object)value);
	}
	
	public String set(String key, String value)
	{
		return (String)put(key, (Object)value);
	}
	
	/*
	 public String get(String key)
	 {
	 return (String)super.get(key);
	 }
	 
	 public String get(int i)
	 {
	 return (String)get(i);
	 }
	 */
	
	public String getAsString(String key) {
		String s = (String)get(key);
		if (s == null) return "";
		return s;
	}
	
	public String getAsString(int i) {
		String s = (String)get(i);
		if (s == null) return "";
		return s;
	}

	/**
	 * make StringHashArray.run
	 */
	public static void main(String args[]) throws Exception
	{
		HashArray v = new HashArray();
		v.put("taro", "090-1234-5678");
		v.put("jiro", "090-2222-2222");
		v.put("mike", "090-3333-3333");
		
		System.out.println(v.get("mike"));
		System.out.println(v.get(0)); // taro
		System.out.println(v.toString());
	}

}
