/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventINPUTPARAM</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="INPUTPARAM">
 *       <attribute name="FRAMES">
 *         <data type="int"/>
 *       </attribute>
 *       <attribute name="MSEC">
 *         <data type="int"/>
 *       </attribute>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="INPUTPARAM"&gt;
 *       &lt;attribute name="FRAMES"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="MSEC"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Thu Oct 02 00:02:10 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventINPUTPARAM implements java.io.Serializable, Cloneable, IEventEvChoice {
    private int FRAMES_;
    private int MSEC_;
    private Element xmlElement;

    /**
     * Creates a <code>EventINPUTPARAM</code>.
     *
     */
    public EventINPUTPARAM() {
    }

    /**
     * Creates a <code>EventINPUTPARAM</code>.
     *
     * @param source
     */
    public EventINPUTPARAM(EventINPUTPARAM source) {
        setup(source);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventINPUTPARAM(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventINPUTPARAM(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventINPUTPARAM(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventINPUTPARAM</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventINPUTPARAM(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the EventINPUTPARAM <code>source</code>.
     *
     * @param source
     */
    public void setup(EventINPUTPARAM source) {
        int size;
        FRAMES_ = source.FRAMES_;
        MSEC_ = source.MSEC_;
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        FRAMES_ = URelaxer.getAttributePropertyAsInt(element, "FRAMES");
        MSEC_ = URelaxer.getAttributePropertyAsInt(element, "MSEC");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventINPUTPARAM((EventINPUTPARAM)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("INPUTPARAM");
        int size;
        URelaxer.setAttributePropertyByInt(element, "FRAMES", this.FRAMES_);
        URelaxer.setAttributePropertyByInt(element, "MSEC", this.MSEC_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventINPUTPARAM</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the int property <b>FRAMES</b>.
     *
     * @return int
     */
    public int getFRAMES() {
        return (FRAMES_);
    }

    /**
     * Sets the int property <b>FRAMES</b>.
     *
     * @param FRAMES
     */
    public void setFRAMES(int FRAMES) {
        this.FRAMES_ = FRAMES;
    }

    /**
     * Gets the int property <b>FRAMES</b>.
     *
     * @return Integer
     */
    public Integer getFRAMESAsInteger() {
        return (new Integer(FRAMES_));
    }

    /**
     * Sets the int property <b>FRAMES</b>.
     *
     * @param FRAMES
     */
    public void setFRAMES(Integer FRAMES) {
        this.FRAMES_ = FRAMES.intValue();
    }

    /**
     * Gets the int property <b>MSEC</b>.
     *
     * @return int
     */
    public int getMSEC() {
        return (MSEC_);
    }

    /**
     * Sets the int property <b>MSEC</b>.
     *
     * @param MSEC
     */
    public void setMSEC(int MSEC) {
        this.MSEC_ = MSEC;
    }

    /**
     * Gets the int property <b>MSEC</b>.
     *
     * @return Integer
     */
    public Integer getMSECAsInteger() {
        return (new Integer(MSEC_));
    }

    /**
     * Sets the int property <b>MSEC</b>.
     *
     * @param MSEC
     */
    public void setMSEC(Integer MSEC) {
        this.MSEC_ = MSEC.intValue();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<INPUTPARAM");
        buffer.append(" FRAMES=\"");
        buffer.append(URelaxer.getString(getFRAMES()));
        buffer.append("\"");
        buffer.append(" MSEC=\"");
        buffer.append(URelaxer.getString(getMSEC()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</INPUTPARAM>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<INPUTPARAM");
        buffer.write(" FRAMES=\"");
        buffer.write(URelaxer.getString(getFRAMES()));
        buffer.write("\"");
        buffer.write(" MSEC=\"");
        buffer.write(URelaxer.getString(getMSEC()));
        buffer.write("\"");
        buffer.write(">");
        buffer.write("</INPUTPARAM>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<INPUTPARAM");
        buffer.print(" FRAMES=\"");
        buffer.print(URelaxer.getString(getFRAMES()));
        buffer.print("\"");
        buffer.print(" MSEC=\"");
        buffer.print(URelaxer.getString(getMSEC()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</INPUTPARAM>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFRAMESAsString() {
        return (URelaxer.getString(getFRAMES()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMSECAsString() {
        return (URelaxer.getString(getMSEC()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFRAMESByString(String string) {
        setFRAMES(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMSECByString(String string) {
        setMSEC(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventINPUTPARAM</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "INPUTPARAM")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "FRAMES")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "MSEC")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventINPUTPARAM</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventINPUTPARAM</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
