/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: NetUtil.java,v 1.7 2009/09/10 08:44:19 nishimoto Exp $
 */
package galatea.httpclient;

import galatea.document.DocError;
import galatea.logger.Logger;
import galatea.util.Util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NetUtil 
{
	private static ArrayList<INetUtilListener> listeners_ = new ArrayList<INetUtilListener>();
    private static CookieManager cookieManager_ = null;
    
	private static void debug(String msg) {
		// System.err.println("NetUtil: " + msg);
	}

	private NetUtil() {}

    public static void createCookieManager() {
    	debug("NetUtil:createCookieManager");
    	for (INetUtilListener l : listeners_) {
    		l.addNetUtilEvent("createCookieManager");
    	}
        cookieManager_ = new CookieManager();
        cookieManager_.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager_);
	}
    
    public static void resetCookieManager() {
    	cookieManager_ = null;
        cookieManager_ = new CookieManager();
        cookieManager_.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager_);
    	for (INetUtilListener l : listeners_) {
    		l.addNetUtilEvent("resetCookieManager");
    	}
    }
	
	public static void addListener(INetUtilListener ls) {
		listeners_.add(ls);
	}
	
	public static String getTopName(Element elem) {
		String topName;
		if (elem.getNodeType() == Node.ELEMENT_NODE) {
			topName = elem.getNodeName();
		} else {
			topName = "";
		}
		return topName;
	}
	
	/**
	// http の場合はまずファイル全体をバイナリ列として取得する
	// バイト列をスキャンして ?> が出現するまでをディレクティブと見なし、
	// encoding を取得する。デフォルトは UTF-8 とする。
	// 以降の文字列は encoding に基づいて解釈し、
	// 内部的には UTF-8 に変換して DOM Parser に解釈させる
	*/
	public static Element loadXMLFile(
			String filename, boolean isPost, String postdata) 
	throws Exception
	{
    	debug("loadXMLFile " + filename + " isPost=" + isPost + " postdata=" + postdata);
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		} catch (ParserConfigurationException e1) {
			debug("c1 " + e1.toString()); throw e1;
		}
		Document root = null;
		if (filename.startsWith("http:")) {
			URL url = null;
			try {
				url = new URL(filename);
			} catch (MalformedURLException e1) {
				debug("c2 " + e1.toString()); throw e1;
			}
			HttpURLConnection uc = null;
			try {
				uc = (HttpURLConnection)url.openConnection();
			} catch (IOException e1) {
				debug("c3 " + e1.toString()); throw e1;
			}

			if (isPost && postdata != null) {
		    	debug("POST=" + postdata);
		    	uc.setRequestMethod("POST");
				uc.setDoOutput(true);
				//uc.setDoInput(true);
				//uc.setAllowUserInteraction(false);
				//uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
				//uc.setUseCaches(false); 
				try {
					uc.connect();
				} catch (IOException e) {
					debug("c7 " + e.toString()); throw e;
				}
				OutputStreamWriter osw = new OutputStreamWriter( uc.getOutputStream() );
				osw.write(postdata);
				osw.flush();
				osw.close();
//				DataOutputStream outStream = null;
//				try {
//					outStream = new DataOutputStream(uc.getOutputStream());
//				} catch (IOException e) {
//					debug("NetUtil c4 " + e.toString()); throw e;
//				}
//				byte[] bytBuff = null;
//				try {
//					bytBuff = postdata.getBytes("UTF-8"); 
//					debug("NetUtil: bytBuff=" + bytBuff);
//				} catch (UnsupportedEncodingException e) {
//					debug("NetUtil c5 " + e.toString()); throw e;
//				}
//				try {
//					outStream.write(bytBuff, 0, bytBuff.length);
//					outStream.flush();
//					outStream.close();
//				} catch (IOException e) {
//					debug("NetUtil c6 " + e.toString()); throw e;
//				}
			} else {
		    	debug("GET...");
				try {
					uc.setRequestMethod("GET");
				} catch (ProtocolException e) {
					debug("NetUtil c8 " + e.toString()); throw e;
				}
			}
			InputStream is = null;
			try {
				is = uc.getInputStream();
			} catch (IOException e1) {
				debug("c9 " + e1.toString()); throw e1;
			}
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			final int SIZE = 8196;
			byte[] buf = new byte[SIZE];
	    	debug("reading...");
			while (true) {
				int n = 0;
				try {
					n = is.read(buf,0,SIZE);
				} catch (IOException e) {
					debug("NetUtil c10 " + e.toString()); throw e;
				}
				if (n == -1) break;
				os.write(buf,0,n);
			}
			byte[] bytes = os.toByteArray();
			try {
				os.close();
			} catch (IOException e1) {
				debug("NetUtil c11 " + e1.toString()); throw e1;
			}
			try {
				is.close();
			} catch (IOException e1) {
				debug("NetUtil c12 " + e1.toString()); throw e1;
			}
			uc.disconnect();
	    	debug("disconnected");

		    // display Cookie 
	    	if (cookieManager_ != null) {
		        CookieStore store = cookieManager_.getCookieStore();
		        List<HttpCookie> cookies = store.getCookies();
	            //System.out.println("Cookies:");
		        for (int i = 0; i < cookies.size(); i++) {
		            HttpCookie cookie = cookies.get(i);
		            //System.out.println("Cookie[" + i + "]: " + cookie);
			        //System.out.flush();
		        	for (INetUtilListener l : listeners_) {
		        		l.addNetUtilEvent("Cookie[" + i + "]: " + cookie);
		        	}
		        }
	    	}
	        
			String encoding = "UTF-8"; // default
			int pos = 0;
			for (int i=0; i < bytes.length; i++) {
				if (bytes[i] == '>' && i > 0 && bytes[i-1] == '?') {
					String line = new String(bytes,0,i+1);
					if (line.startsWith("<?xml ")) {
						String s = line.replaceAll("\"", "'");
						// encoding='xxx'
						String e = Util.getFirstGroup(".*encoding[\\s]*=[\\s]*'([^']+)'.*", s);
						if (e != null) {
							encoding = e;
						}
					}
					pos = i+1;
					break;
				}
			}
	    	debug("doing builder.parse()");
			int len = bytes.length - pos;
			String content = null;
			try {
				content = new String(bytes, pos, len, encoding);
			} catch (UnsupportedEncodingException e) {
				debug("NetUtil c13 " + e.toString()); throw e;
			}
			InputStream is2 = null;
			try {
				is2 = new ByteArrayInputStream(content.getBytes("UTF-8"));
			} catch (UnsupportedEncodingException e1) {
				debug("NetUtil c14 " + e1.toString()); throw e1;
			}
			try {
				debug("trying to parse as XML");
				root = builder.parse(is2);
			} catch (SAXException e) {
				debug("NetUtil c15 " + e.toString()); throw e;
			} catch (IOException e) {
				debug("NetUtil c16 " + e.toString()); throw e;
			}
        	for (INetUtilListener l : listeners_) {
        		l.addNetUtilEvent("fetched and parsed " + filename 
        				+ (isPost && postdata != null ? " [POST]" : " [GET]") );
        	}
		} else {
	    	debug("local file");
			try {
				root = builder.parse(filename);
			} catch (SAXException e) {
				debug("NetUtil c17 " + e.toString()); throw e;
			} catch (IOException e) {
				debug("NetUtil c18 " + e.toString()); throw e;
			}
        	for (INetUtilListener l : listeners_) {
        		l.addNetUtilEvent("parsed " + filename);
        	}
		}
		Element elem = root.getDocumentElement();
		return elem;
	}
	
	public static Element loadXMLFile(String filename) throws Exception
	{
		return loadXMLFile(filename, false, null);
	}
	
	
	public static String loadTextFile(String filename) throws Exception
	{
		String doc = Util.readURL(filename);
		if (Util.getError().equals("")) {
			return doc;
		}
		throw new DocError(Util.getError());
	}
	
	public static String makeString(Element element) {
		TransformerFactory factory = TransformerFactory.newInstance();
		Transformer transformer;
		try {
			transformer = factory.newTransformer();
		} catch (TransformerConfigurationException e) {
			return e.toString(); // e.printStackTrace();
		}
		DOMSource src = new DOMSource(element);
		StringWriter writer = new StringWriter();
		StreamResult target = new StreamResult(writer);
		try {
			transformer.transform(src, target);
		} catch (Exception e) {
			return e.toString(); // e.printStackTrace();
		}
		String ws = new String(writer.getBuffer());
		return ws;
	}
	
	public static void main(String args[]) throws Exception
	{
		createCookieManager();
		Element e = loadXMLFile(
				// "http://localhost:3000/product/show.vxml?id=957451030", false, ""
				"http://localhost:3000/product/show.vxml", true, "id=957451030"
				);
    	String s = makeString(e);
		System.err.println(s);
	}
	
}
