/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>VxmlMediaRef</b> is generated from vxml20.rng by Relaxer.
 *
 * @version vxml20.rng (Thu Oct 02 00:02:04 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlMediaRef implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMediaChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    // List<VxmlNative>
    private java.util.List native_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlMediaRef</code>.
     *
     */
    public VxmlMediaRef() {
    }

    /**
     * Creates a <code>VxmlMediaRef</code>.
     *
     * @param source
     */
    public VxmlMediaRef(VxmlMediaRef source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlMediaRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlMediaRef(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>VxmlMediaRef</code> by the VxmlMediaRef <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlMediaRef source) {
        int size;
        this.native_.clear();
        size = source.native_.size();
        for (int i = 0;i < size;i++) {
            addNative((VxmlNative)source.getNative(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlMediaRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        native_.clear();
        while (true) {
            if (VxmlNative.isMatch(stack)) {
                addNative(new VxmlNative(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlMediaRef((VxmlMediaRef)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        size = this.native_.size();
        for (int i = 0;i < size;i++) {
            VxmlNative value = (VxmlNative)this.native_.get(i);
            value.makeElement(element);
        }
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the VxmlNative property <b>native</b>.
     *
     * @return VxmlNative[]
     */
    public VxmlNative[] getNative() {
        VxmlNative[] array = new VxmlNative[native_.size()];
        return ((VxmlNative[])native_.toArray(array));
    }

    /**
     * Sets the VxmlNative property <b>native</b>.
     *
     * @param nativeValue
     */
    public void setNative(VxmlNative[] nativeValue) {
        this.native_.clear();
        for (int i = 0;i < nativeValue.length;i++) {
            addNative(nativeValue[i]);
        }
        for (int i = 0;i < nativeValue.length;i++) {
            nativeValue[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the VxmlNative property <b>native</b>.
     *
     * @param nativeValue
     */
    public void setNative(VxmlNative nativeValue) {
        this.native_.clear();
        addNative(nativeValue);
        if (nativeValue != null) {
            nativeValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlNative property <b>native</b>.
     *
     * @param nativeValue
     */
    public void addNative(VxmlNative nativeValue) {
        this.native_.add(nativeValue);
        if (nativeValue != null) {
            nativeValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlNative property <b>native</b>.
     *
     * @param nativeValue
     */
    public void addNative(VxmlNative[] nativeValue) {
        for (int i = 0;i < nativeValue.length;i++) {
            addNative(nativeValue[i]);
        }
        for (int i = 0;i < nativeValue.length;i++) {
            nativeValue[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the VxmlNative property <b>native</b>.
     *
     * @return int
     */
    public int sizeNative() {
        return (native_.size());
    }

    /**
     * Gets the VxmlNative property <b>native</b> by index.
     *
     * @param index
     * @return VxmlNative
     */
    public VxmlNative getNative(int index) {
        return ((VxmlNative)native_.get(index));
    }

    /**
     * Sets the VxmlNative property <b>native</b> by index.
     *
     * @param index
     * @param nativeValue
     */
    public void setNative(int index, VxmlNative nativeValue) {
        this.native_.set(index, nativeValue);
        if (nativeValue != null) {
            nativeValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlNative property <b>native</b> by index.
     *
     * @param index
     * @param nativeValue
     */
    public void addNative(int index, VxmlNative nativeValue) {
        this.native_.add(index, nativeValue);
        if (nativeValue != null) {
            nativeValue.rSetParentRNode(this);
        }
    }

    /**
     * Remove the VxmlNative property <b>native</b> by index.
     *
     * @param index
     */
    public void removeNative(int index) {
        this.native_.remove(index);
    }

    /**
     * Remove the VxmlNative property <b>native</b> by object.
     *
     * @param nativeValue
     */
    public void removeNative(VxmlNative nativeValue) {
        this.native_.remove(nativeValue);
    }

    /**
     * Clear the VxmlNative property <b>native</b>.
     *
     */
    public void clearNative() {
        this.native_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.native_.size();
        for (int i = 0;i < size;i++) {
            VxmlNative value = (VxmlNative)this.native_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.native_.size();
        for (int i = 0;i < size;i++) {
            VxmlNative value = (VxmlNative)this.native_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.native_.size();
        for (int i = 0;i < size;i++) {
            VxmlNative value = (VxmlNative)this.native_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(native_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMediaRef</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMediaRef</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack.makeClone();
        boolean $match$ = false;
        Element element = target.peekElement();
        Element child;
        if (!VxmlNative.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!VxmlNative.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if ($match$) {
            stack.eat(target);
        }
        return ($match$);
    }
}
