package galatea.dialog.window;

import galatea.util.Property;
import galatea.util.Util;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class WindowUtil {
	@SuppressWarnings("unchecked")
	/**
	 * set look and feel (use nimbus if available)
	 */
	public static void setLookAndFeel() {
		final String metal   = "javax.swing.plaf.metal.MetalLookAndFeel";
		final String mac     = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
		final String motif   = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
		final String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
		final String gtk     = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
		final String nimbus  = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
		String lafname = nimbus;
		boolean nimbusUsed = false;
		try {
			Class lnfClass = Class.forName(lafname);
			LookAndFeel newLAF = (LookAndFeel) (lnfClass.newInstance());
			if (newLAF.isSupportedLookAndFeel()) {
				try {
					UIManager.setLookAndFeel(newLAF);
					nimbusUsed = true;
				} catch (Exception e) {
				}
			}
		} catch (Exception e) {
		}
		if (!nimbusUsed) {
	        try {
	            UIManager.getInstalledLookAndFeels();
	            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	        } catch(Exception e) {
	        }
		}
	}

	public static void fixFont(JTextArea tf) {
		if (Property.getAsBoolean("DM.Window.FixFont", false)) {
			if (Util.isWindows() && Util.isJapanese()) {
				tf.setFont(new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", Font.PLAIN, 14)); // "MS Gothic"
			} else if (Util.isLinux() && Util.isJapanese()) {
				tf.setFont(new Font("Kochi Gothic", Font.PLAIN, 14));
			}
		}
	}
	
	/**
	 * @return GridBagConstraints instance
	 */
	public static GridBagConstraints initPos() {
		GridBagConstraints constraints = new GridBagConstraints();
		constraints.anchor = GridBagConstraints.NORTH;
		constraints.fill = GridBagConstraints.BOTH;
		constraints.insets = new Insets(3, 3, 3, 3);
		constraints.gridy = 0;
		constraints.gridheight = 1;
		return constraints;
	}
	
	/**
	 * this constraint cannot expand
	 * @param c : GridBagConstraints
	 * @param x : grid x
	 * @param width : grid width
	 */
	public static void setPos(GridBagConstraints c, int x, int width) {
		setPos(c, x, width, 0, 0);
	}

	/**
	 * this constraint can expand only for holizontal
	 * @param c : GridBagConstraints
	 * @param x : grid x
	 * @param width : grid width
	 * @param wx : weight x
	 */
	public static void setPos(GridBagConstraints c, int x, int width, int wx) {
		setPos(c, x, width, wx, 0);
	}
	
	/**
	 * this constraint can expand both for holizontal and vertical
	 * @param c : GridBagConstraints
	 * @param x : grid x
	 * @param width : grid width
	 * @param wx : weight x
	 * @param wy : weight y
	 */
	public static void setPos(GridBagConstraints c, int x, int width, int wx, int wy) {
		c.gridx = x;
		c.gridwidth = width;
		c.weightx = wx;
		c.weighty = wy;
	}
	
	/**
	 * increment c.gridy 
	 * @param c : GridBagConstraints
	 */
	public static void nextRow(GridBagConstraints c) { 
		c.gridy++;
	}
	
}
