#!/usr/bin/ruby -Ku
# coding: utf-8
# $Id: galatea_generate.rb,v 1.7 2009/08/24 13:19:48 nishimoto Exp $
# (c) Takuya NISHIMOTO 

require 'optparse'
require 'fileutils'

%w[ generator.rb app_generator.rb yaml_reader.rb ].each do |f|
  require File.join($generator_dir, 'lib', f)
end

dry_run = false
ARGV.options do |opt|
  opt.on('-n', '--dry-run') do 
    dry_run = true
  end
  opt.parse!
end

target_dir = ARGV.first
unless target_dir
  puts "Usage: galatea-generate (target-dir)"
  exit
end
target_dir = File.join(Dir.pwd, target_dir)

args = {:verbose => true, :noop => dry_run}
FileUtils.mkdir_p target_dir, args
FileUtils.mkdir_p File.join(target_dir, 'config'), args
FileUtils.mkdir_p File.join(target_dir, 'script'), args

g = AppGenerator.new
g.config = YAMLReader.new([File.join($generator_dir, 'generator.yml')])
g.dry_run = dry_run
g.dmpath = $generator_dir
app_skel_dir = File.join($generator_dir, 'app_skel')
g.generate app_skel_dir, 'runner',     target_dir, 'script', 0755
g.generate app_skel_dir, 'runner.yml', target_dir, 'config'
runner_skel_dir = File.join($generator_dir, 'skel')
FileUtils.mkdir_p "#{target_dir}/skel"
Dir.glob("#{runner_skel_dir}/*.txt").each do |f|
  FileUtils.cp(f, "#{target_dir}/skel/#{File.basename(f)}")
  puts "#{target_dir}/skel/#{File.basename(f)} generated."
end

