#!/usr/bin/ruby -Ku
# coding: utf-8
# installer of /usr/local/galatea-dialog
# usage:
# $ sudo dpkg -r galatea-dialog
# $ mkdir galatea-dialog-yyyymmdd
# $ cd galatea-dialog-yyyymmdd
# $ sudo checkinstall ruby /PATH/TO/setup_dialog.rb
# alternate source location: http://sourceforge.jp/projects/galatea/
# requires : galatea-engine,galatea-ja-chaone,galatea-ja-unidic,chasen
require 'fileutils'

dry_run = false

EXIT_SUCCESS = 0
EXIT_FAILURE = -1
TARGET_DIR = "/usr/local/galatea-dialog"
USR_BIN_DIR = "/usr/local/bin"

unless dry_run
  if FileTest.exist?(TARGET_DIR)
    puts "#{TARGET_DIR} is already installed" 
    exit EXIT_SUCCESS
  end
end

dir = File.expand_path(File.join(File.dirname(__FILE__), "../"))

files = []
Dir.glob("#{dir}/**/*").each do |f|
  next if FileTest.directory? f
  f.gsub!(dir, '')
  f.gsub!(/^\//, '') # remove first /
  # files to exclude
  next if f =~ /CVS/			  	
  next if f =~ /\.class$/			  	
  next if f =~ /~$/
  next if f =~ /sdoc/
  next if f =~ /errors/
  next if f =~ /relaxer/
  next if f =~ /misc/
  files << f
end
files.each do |f| 
  t = "#{TARGET_DIR}/#{f}"
  d = File.dirname(t)
  if dry_run
    puts "mkdir_p #{d} ; cp #{dir}/#{f} #{d}"
  else
    begin
      FileUtils.mkdir_p d
      FileUtils.cp_r "#{dir}/#{f}", d, :preserve => true
    rescue => e
      puts e.message
      exit
    end
  end
end
exit if dry_run

files = []
%w[ files bin ].each do |f|
  files << "#{dir}/#{f}"
end

begin
  FileUtils.mkdir_p USR_BIN_DIR
  FileUtils.cp "#{dir}/galatea-killall", USR_BIN_DIR
  FileUtils.chmod 0755, "#{USR_BIN_DIR}/galatea-killall"
rescue => e
  puts e.message
  exit
end

%w[galatea-generate galatea-runner].each do |f|
  begin
    File.open("#{USR_BIN_DIR}/#{f}", "w") do |outfile|
      outfile.write <<"EOS"
#!/usr/bin/ruby -Ku
# coding: utf-8
load "#{TARGET_DIR}/#{f}"
EOS
    end
    FileUtils.chmod 0755, "#{USR_BIN_DIR}/#{f}"
  rescue => e
    puts e.message
    exit
  end
end

if FileTest.exist?(TARGET_DIR)
  puts "#{TARGET_DIR} is succssfully installed" 
  exit EXIT_SUCCESS
else
  puts "Error: #{TARGET_DIR} cannot be installed" 
  exit EXIT_FAILURE
end
