// Sock.cpp: CSock NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include "Sock.h"

#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

//
// O		:CSock::CSock()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::CSock()
{
	m_hSocket = INVALID_SOCKET;
	InitializeCriticalSection( &m_CriticalSection );
}

//
// O		:CSock::~CSock()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::~CSock()
{
}

/*
//
// O		:void CSock::Attach( SOCKET hSocket )
// @\		:\Pbgnh֘At
// 		:hSocket - \Pbgnh
// ߂l	:Ȃ
//
void CSock::Attach( SOCKET hSocket )
{
	m_hSocket = hSocket;
}

//
// O		:void CSock::Detach()
// @\		:õ\Pbgnh
// 		:Ȃ
// ߂l	:Ȃ
//
void CSock::Detach()
{
	if( m_hSocket != INVALID_SOCKET )
	{
		shutdown( m_hSocket, 0x02 );
		closesocket( m_hSocket );
		m_hSocket = INVALID_SOCKET;
	}
}
*/

//
// O		:bool CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
// @\		:V\Pbgnh쐬
// 		:nAddrFamily - AhXt@~
//			:nSocketType - \Pbg̎
//			:nProtocol - vgR
// ߂l	: - true s - false
//
bool CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
{
	m_hSocket = socket( nAddrFamily, nSocketType, nProtocol );
	if( m_hSocket == INVALID_SOCKET ){return false;}
	return true;
}

//
// O		:bool CSock::Bind( CSockAddr *addr )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Bind(int nPort )
{
//	this->m_InetSockAddrFrom.sin_addr.s_addr = inet_addr( lpszIP );
	this->m_InetSockAddrTo.sin_addr.s_addr = htonl(INADDR_ANY);
	this->m_InetSockAddrFrom.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddrFrom.sin_family = AF_INET;

	if( m_hSocket == INVALID_SOCKET ){return false;}

	if( bind( m_hSocket, (struct sockaddr*)&m_InetSockAddrFrom, sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return false;
	return true;
}

//
// O		:bool CSock::Listen( int nMaxCon )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Listen( int nMaxCon )
{
	if( m_hSocket == INVALID_SOCKET ||
		nMaxCon < 1
		){return false;}

	if( listen( m_hSocket, nMaxCon ) == SOCKET_ERROR )
		return false;
	return true;
}

//
// O		:bool CSock::Accept()
// @\		:̃\PbgŐڑṽANZvg
// 		:&sock - ANZvgp̃\Pbg
// ߂l	: - TRUE s - FALSE
//
bool CSock::Accept()
{
	if( m_hSocket == INVALID_SOCKET ){return false;}

	printf("FSM Server mode. waiting...\n");

	int nSize = sizeof( sockaddr );
	m_hClientSocket = accept( m_hSocket, NULL, &nSize );

	printf("conected\n");

	return true;
}

/*
//
// O		:bool CSock::Connect( CSockAddr *addr )
// @\		:̃AhXɐڑ
// 		:*addr - ڑAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Connect( LPCTSTR lpszIP, int nPort )
{
	this->m_InetSockAddrTo.sin_addr.s_addr = inet_addr( lpszIP );
	this->m_InetSockAddrTo.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddrTo.sin_family = AF_INET;

	if( m_hSocket == INVALID_SOCKET ){return false;}

	if( connect( m_hSocket, (struct sockaddr*)&m_InetSockAddrTo, sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return false;
	return true;
}
*/

//
// O		:void CSock::Close()
// @\		:õ\Pbgnh
// 		:
// ߂l	:
//
void CSock::Close()
{
	shutdown( m_hClientSocket, 0x02 );
	closesocket( m_hClientSocket );
	m_hClientSocket = INVALID_SOCKET;

	shutdown( m_hSocket, 0x02 );
	closesocket( m_hSocket );
	m_hSocket = INVALID_SOCKET;
}

//
// O		:int CSock::Send( const char *szMsg, int nByte )
// @\		:sMsgnByteoCg
// 		:sMsg - Mobt@̃|C^
//			:nByte - oCg
// ߂l	:ۂɑꂽoCg
//
int CSock::Send( const char *szMsg, size_t nByte )
{
	if( m_hClientSocket == INVALID_SOCKET ){return 0;}
	return send( m_hClientSocket, szMsg, nByte, 0 );
}

//
// O		:int CSock::Recv( char *szBuff )
// @\		:MāAsBuffɊi[
// 		:szBuff - Mpobt@̃|C^
// ߂l	:MoCg
//
int CSock::Recv( char *szBuff )
{
	if( m_hClientSocket == INVALID_SOCKET ){return 0;}
	return recv( m_hClientSocket, szBuff, RECV_BUFFER_SIZE, 0 );
}

//
// O		:bool CSock::Detach()
// @\		:õ\PbgnhLׂ
// 		:
// ߂l	:L - true  - false
//
bool CSock::IsValid()
{
	if( m_hSocket == INVALID_SOCKET ){return false;}
	return true;
}
