#ifndef ABSTRACTWORKER_H
#define ABSTRACTWORKER_H

#include <QObject>
#include <QMutex>

class AbstractWorker : public QObject
{
    Q_OBJECT
public:
    explicit AbstractWorker();

    void    abort();
    void    start();

protected:
    QMutex  m_mutex;

    bool    isAborted();

signals:
    void    finished(bool abort = false);

public slots:
    virtual void    run() = 0;

private:
    bool        m_abort;
    QThread*    m_thread;
};

#endif // ABSTRACTWORKER_H
