#ifndef COPYWORKER_H
#define COPYWORKER_H

#include "operationworker.h"
#include "global.h"

class CopyMoveWorker : public OperationWorker
{
    Q_OBJECT
public:
    explicit CopyMoveWorker();

    void setCopyList(const QStringList &list) {
        m_CopyList = list;
    }
    void setTargetDir(const QString &path) {
        m_tgtDir = path;
    }
    void setMoveMode(bool move) {
        m_Move = move;
    }

    void endAsking() {
        QMutexLocker lock(&m_AskingMutex);
        m_Asking = false;
    }

signals:
    void askOverWrite(QString *copyMethod, QString *alias,
                      const QString &srcPath, const QString &tgtPath);

public slots:

private:
    QStringList m_CopyList;
    QString m_tgtDir;
    StringMap m_CopyMap;
    QMutex m_AskingMutex;
    bool m_Asking;
    bool m_Move;

    bool isAsking() {
        QMutexLocker lock(&m_AskingMutex);
        return m_Asking;
    }

    void Listup(const QString &srcPath, const QString &tgtPath);

    // AbstractWorker interface
public slots:
    void run();

    // OperationWorker interface
public:
    QString initialText() const;
};

#endif // COPYWORKER_H
