#ifndef FILEREADWORKER_H
#define FILEREADWORKER_H

#include "abstractworker.h"

#include <QFile>

class FileReadWorker : public AbstractWorker
{
    Q_OBJECT
public:
    explicit FileReadWorker();

    bool    open(const QString &path);

private:
    QFile   m_file;

signals:
    void    size(int value);
    void    progress(int value);
    void    resultReady(const QByteArray &data);

public slots:

    // AbstractWorker interface
public slots:
    void run();
};

#endif // FILEREADWORKER_H
