#include "mainwindow.h"
#include "preferences.h"
#include "folderview.h"

#include <QApplication>
#include <QDebug>
#include <QHeaderView>

///////////////////////////////////////////////////////////////////////////////
/// \brief FolderView::FolderView
/// \param parent   親ウィジェット
///
/// コンストラクタ
///
FolderView::FolderView(QWidget *parent) :
    QTableView(parent),
    m_p(this)
{
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FolderView::initialize
/// \param w    メインウィンドウオブジェクト
///
/// 初期化処理を行います。
///
void FolderView::initialize(MainWindow *w)
{
    qDebug() << "FolderView::initialize()";

    connect(this, SIGNAL(doubleClicked(QModelIndex)), w, SLOT(onOpen(QModelIndex)));
    connect(this, SIGNAL(prefs_updated()), w, SLOT(prefs_updated()));
    connect(&m_p, SIGNAL(copyItems(QStringList,QString)), w, SLOT(copyItems(QStringList,QString)));
    connect(&m_p, SIGNAL(moveItems(QStringList,QString)), w, SLOT(moveItems(QStringList,QString)));

    installEventFilter(w);
    viewport()->installEventFilter(&m_p);
    viewport()->installEventFilter(w);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FolderView::onScaleUp
///
/// 文字を大きくします。
///
void FolderView::onScaleUp()
{
    Preferences prefs(this);
    QFont font = prefs.getFolderViewFont();
    font.setPointSize(font.pointSize() + 1);
    prefs.setFolderViewFont(font);

    emit prefs_updated();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FolderView::onScaleDown
///
/// 文字を小さくします。
///
void FolderView::onScaleDown()
{
    Preferences prefs(this);
    QFont font = prefs.getFolderViewFont();
    font.setPointSize(font.pointSize() - 1);
    prefs.setFolderViewFont(font);

    emit prefs_updated();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FolderView::setModel
/// \param model    モデルオブジェクト
///
/// モデルを設定します。
///
void FolderView::setModel(QAbstractItemModel *model)
{
    if (this->model()) {
        this->model()->disconnect(this);
    }

    QTableView::setModel(model);

    if (this->model()) {
        connect(this->model(), SIGNAL(modelAboutToBeReset()), &m_p, SLOT(model_PreReset()));
        connect(this->model(), SIGNAL(modelReset()), &m_p, SLOT(model_PostReset()));

        // 列の幅を設定する
        horizontalHeader()->setSectionResizeMode(QHeaderView::ResizeToContents);
        horizontalHeader()->setSectionResizeMode(FolderModel::Name,
                                                 QHeaderView::Stretch);
    }
}

