#ifndef FOLDERVIEW_H
#define FOLDERVIEW_H

#include "folderview_private.h"
#include "foldermodel.h"

#include <QTableView>
class MainWindow;

class FolderView : public QTableView
{
    Q_OBJECT

public:
    explicit FolderView(QWidget *parent = 0);

    void            initialize(MainWindow *w);
    FolderModel*    folderModel() const;

private:
    FolderView_Private  m_p;

signals:
    void    prefs_updated();

private slots:
    void    onScaleUp();
    void    onScaleDown();

    // QAbstractItemView interface
public:
    void setModel(QAbstractItemModel *model);

};

inline FolderModel *FolderView::folderModel() const
{
    return static_cast<FolderModel*>(model());
}

#endif // FOLDERVIEW_H
