#include "foldermodel.h"
#include "sortdialog.h"
#include "ui_sortdialog.h"

///////////////////////////////////////////////////////////////////////////////
/// \brief SortDialog::SortDialog
/// \param parent   親ウィジェット
///
/// コンストラクタ
///
SortDialog::SortDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SortDialog),
    m_model(NULL)
{
    ui->setupUi(this);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief SortDialog::~SortDialog
///
/// デストラクタ
///
SortDialog::~SortDialog()
{
    delete ui;
}

///////////////////////////////////////////////////////////////////////////////
/// \brief SortDialog::setModel
/// \param m    フォルダモデル
///
/// モデルを設定します。
///
void SortDialog::setModel(FolderModel *m)
{
    m_model = m;
    QDir::SortFlags sort = m->sorting();

    if (sort & QDir::Time) {
        ui->sortByDate->setChecked(true);
        if (sort & QDir::Reversed)
            ui->orderAsc->setChecked(true);
    }
    else if (sort & QDir::Size) {
        ui->sortBySize->setChecked(true);
        if (sort & QDir::Reversed)
            ui->orderAsc->setChecked(true);
    }
    else if (sort & QDir::Type) {
        ui->sortByType->setChecked(true);
        if (sort & QDir::Reversed)
            ui->orderDesc->setChecked(true);
    }
    else {
        ui->sortByName->setChecked(true);
        if (sort & QDir::Reversed)
            ui->orderDesc->setChecked(true);
    }

    if (sort & QDir::DirsFirst) {
        ui->dirsFirst->setChecked(true);
    }
    else if (sort & QDir::DirsLast) {
        ui->dirsLast->setChecked(true);
    }
    else {
        ui->dirsLast->setChecked(true);
    }

    if (sort & QDir::IgnoreCase)
        ui->ignoreCase->setChecked(true);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief SortDialog::accept
///
/// OKボタンクリック時の処理を行います。
///
void SortDialog::accept()
{
    QDir::SortFlags sort;

    if (ui->sortByDate->isChecked()) {
        sort |= QDir::Time;
        if (ui->orderAsc->isChecked())
            sort |= QDir::Reversed;
    }
    else if (ui->sortBySize->isChecked()) {
        sort |= QDir::Size;
        if (ui->orderAsc->isChecked())
            sort |= QDir::Reversed;
    }
    else if (ui->sortByType->isChecked()) {
        sort |= QDir::Type;
        if (ui->orderDesc->isChecked())
            sort |= QDir::Reversed;
    }
    else {
        sort |= QDir::Name;
        if (ui->orderDesc->isChecked())
            sort |= QDir::Reversed;
    }

    if (ui->dirsFirst->isChecked()) {
        sort |= QDir::DirsFirst;
    }
    else if (ui->dirsLast->isChecked()) {
        sort |= QDir::DirsLast;
    }

    if (ui->ignoreCase->isChecked())
        sort |= QDir::IgnoreCase;

    m_model->setSorting(sort);
    m_model->refresh();

    QDialog::accept();
}
