#ifndef THUMBNAILWORKER_H
#define THUMBNAILWORKER_H

#include "abstractworker.h"

#include <QSize>
#include <QPixmap>

class ThumbnailWorker : public AbstractWorker
{
    Q_OBJECT
public:
    explicit ThumbnailWorker();

    void    addPath(const QString &path);
    void    clearPath();

private:
    QStringList m_pathList;

    QString     getPath();

signals:
    void    resultReady(const QString &path, const QPixmap &pixmap);

    // AbstractWorker interface
public slots:
    void run();
};

#endif // THUMBNAILWORKER_H
