/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketPool {
    private static final Logger logger = Logger.getLogger("messaging");
    private int capacity;
    private Stack<DatagramChannel> sockStack;

    SocketPool(int capacity) {
        this.capacity = capacity;
        this.sockStack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel get() {
        DatagramChannel sock = null;
        Stack<DatagramChannel> stack = this.sockStack;
        synchronized (stack) {
            try {
                sock = this.sockStack.pop();
            }
            catch (EmptyStackException e) {
                try {
                    sock = DatagramChannel.open();
                }
                catch (IOException e0) {
                    logger.log(Level.WARNING, "Cound not instantiate a DatagramSocket.");
                }
            }
        }
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DatagramChannel sock) {
        Stack<DatagramChannel> stack = this.sockStack;
        synchronized (stack) {
            if (this.sockStack.size() < this.capacity) {
                this.sockStack.push(sock);
            }
        }
    }
}

