/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.dht.DHT;
import ow.dht.DHTFactory;
import ow.messaging.util.AccessController;
import ow.oasis.OASISResponder;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.tool.dhtshell.commands.ClearCommand;
import ow.tool.dhtshell.commands.GetCommand;
import ow.tool.dhtshell.commands.HaltCommand;
import ow.tool.dhtshell.commands.HelpCommand;
import ow.tool.dhtshell.commands.InitCommand;
import ow.tool.dhtshell.commands.LocaldataCommand;
import ow.tool.dhtshell.commands.PutCommand;
import ow.tool.dhtshell.commands.QuitCommand;
import ow.tool.dhtshell.commands.RemoveCommand;
import ow.tool.dhtshell.commands.ResumeCommand;
import ow.tool.dhtshell.commands.SetSecretCommand;
import ow.tool.dhtshell.commands.SetTTLCommand;
import ow.tool.dhtshell.commands.StatusCommand;
import ow.tool.dhtshell.commands.SuspendCommand;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;
import ow.tool.util.toolframework.AbstractDHTBasedTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main
extends AbstractDHTBasedTool<String>
implements EmulatorControllable,
Interruptible {
    private static final String COMMAND = "owdhtshell";
    private static final int SHELL_PORT = -1;
    public static final int XMLRPC_PORT_DIFF = 1;
    private static final int XMLRPC_PORT_RANGE = 100;
    public static final String ENCODING = "UTF-8";
    private static final Class[] COMMANDS = new Class[]{StatusCommand.class, InitCommand.class, GetCommand.class, PutCommand.class, RemoveCommand.class, SetTTLCommand.class, SetSecretCommand.class, LocaldataCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class, ClearCommand.class, SuspendCommand.class, ResumeCommand.class};
    private static final List<Command<DHT<String>>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<DHT<String>>> commandTable = ShellServer.createCommandTable(commandList);
    private Thread mainThread = null;

    @Override
    protected void usage(String command) {
        super.usage(command, "[-p <shell port>] [--acl <ACL file>] [-n] [--web] [--showmap] [--oasis]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        Shell<DHT<String>> stdioShell = null;
        stdioShell = this.init(args, System.in, System.out, true);
        if (stdioShell != null) {
            stdioShell.run();
        }
    }

    @Override
    public Writer invoke(String[] args, PrintStream out) {
        Shell<DHT<String>> stdioShell = this.init(args, null, out, false);
        if (stdioShell != null) {
            return stdioShell.getWriter();
        }
        return null;
    }

    private Shell<DHT<String>> init(String[] args, InputStream in, PrintStream out, boolean interactive) {
        int shellPort = -1;
        AccessController ac = null;
        boolean disableStdin = false;
        boolean invokeXMLRPCServer = false;
        boolean showMapOnWebInterface = false;
        int oasisPort = -1;
        this.mainThread = Thread.currentThread();
        Options opts = this.getInitialOptions();
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        opts.addOption("n", "disablestdin", false, "disable standard input");
        opts.addOption("W", "web", false, "invoke a web/XML-RPC server");
        opts.addOption("M", "showmap", false, "show a Google Map on a web interface");
        opts.addOption("O", "oasis", true, "invoke an OASIS responder");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        parser = null;
        opts = null;
        String optVal = cmd.getOptionValue('p');
        if (optVal != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return null;
            }
        }
        if (cmd.hasOption('n')) {
            disableStdin = true;
        }
        if (cmd.hasOption('W')) {
            invokeXMLRPCServer = true;
        }
        if (cmd.hasOption('M')) {
            showMapOnWebInterface = true;
        }
        if ((optVal = cmd.getOptionValue("O")) != null) {
            oasisPort = Integer.parseInt(optVal);
        }
        DHT<String> dht = null;
        try {
            dht = super.initialize((short)1, (short)0, DHTFactory.getDefaultConfiguration(), COMMAND, cmd);
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return null;
        }
        cmd = null;
        XmlRpcDHTServer rpcServer = null;
        if (invokeXMLRPCServer) {
            rpcServer = new XmlRpcDHTServer(dht, showMapOnWebInterface);
            int xmlrpcPort = dht.getConfiguration().getContactPort() + 1;
            try {
                String url = rpcServer.start(xmlrpcPort, 100);
                System.out.println("Web and XML-RPC server: " + url);
            }
            catch (Exception e) {
                System.err.println("Failed to start a web server.");
                e.printStackTrace();
                return null;
            }
        }
        if (oasisPort >= 1 && oasisPort < 65535) {
            OASISResponder s = null;
            try {
                s = new OASISResponder(oasisPort);
            }
            catch (IOException e) {
                System.err.println("Failed to start an OASIS responder on port " + oasisPort);
                e.printStackTrace();
                return null;
            }
            Thread t = new Thread(s);
            t.setName("OASIS responder");
            t.start();
            System.out.println("OASIS responder: port " + oasisPort);
        }
        ShellServer<DHT<String>> shellServ = new ShellServer<DHT<String>>(commandTable, commandList, new ShowPromptPrinter(), new NoCommandPrinter(), null, dht, shellPort, ac);
        shellServ.addInterruptible(this);
        if (rpcServer != null) {
            shellServ.addInterruptible(rpcServer);
        }
        Shell<DHT<String>> stdioShell = null;
        if (disableStdin) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {}
        } else {
            stdioShell = new Shell<DHT<String>>(in, out, shellServ, dht, interactive);
        }
        return stdioShell;
    }

    @Override
    public void interrupt() {
        if (this.mainThread != null && !this.mainThread.equals(Thread.currentThread())) {
            this.mainThread.interrupt();
        }
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

