/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell.commands;

import java.io.PrintStream;
import java.io.Serializable;
import ow.id.ID;
import ow.id.IDUtility;
import ow.mcast.Mcast;
import ow.routing.RoutingException;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MulticastCommand
implements Command<Mcast> {
    private static final String[] NAMES = new String[]{"multicast"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "multicast <group name> <message>";
    }

    @Override
    public boolean execute(ShellContext<Mcast> context) {
        String msg;
        Mcast mcast = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (args.length <= 2) {
            msg = args[1];
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(args[1]);
            for (int i = 2; i < args.length; ++i) {
                sb.append(" ").append(args[i]);
            }
            msg = sb.toString();
        }
        ID groupID = IDUtility.parseID(args[0], mcast.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        try {
            mcast.multicast(groupID, (Serializable)((Object)msg));
            out.print("sent.\r\n");
        }
        catch (RoutingException e) {
            out.print("routing failed: " + e + "\r\n");
        }
        out.flush();
        return false;
    }
}

