/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import ow.id.ID;
import ow.messaging.MessagingAddress;
import ow.stat.NodeCollectorCallback;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.IDSpacePanel;
import ow.tool.util.vizframework.ImageManager;
import ow.tool.util.vizframework.LineType;
import ow.tool.util.vizframework.VisualizerFrame;

public class Visualizer
implements NodeCollectorCallback {
    public static final String SOFTWARE_NAME = "Overlay Visualizer";
    public static final boolean SELF_DOUBLE_BUFFERING = true;
    public static final boolean SELF_DRAWING = true;
    public static final double DEFAULT_SCALE = 1.0;
    public static final int IMAGE_SCALING_ALGORITHM = 4;
    public static final LineType LINE_TYPE = LineType.BEZIER_CURVE;
    public static final float MESSAGING_LINE_WIDTH = 2.0f;
    public static final float CONNECTION_LINE_WIDTH = 2.5f;
    public static final int MESSAGING_LINE_ALPHA_DECREASEMENT = 48;
    public static final int CONNECTION_LINE_ALPHA = 192;
    public static final long EXPIRATION = 1000L;
    public static final long EXPIRATION_CHECK_INTERVAL = 200L;
    public static final long MOMENT_EXPIRATION = 100L;
    public static final double DISPLACEMENT_BY_ARROW_KEYS = 15.0;
    private VisualizerFrame vizFrame;
    private ImageManager imageManager = new ImageManager();
    private IDSpacePanel idSpacePanel;
    private int numOfNodes = 0;

    public Visualizer(int idSizeInBit) throws Exception {
        this.vizFrame = new VisualizerFrame(this.imageManager, idSizeInBit);
        this.idSpacePanel = this.vizFrame.getIDSpacePanel();
    }

    public void setIDSizeInBit(int size) {
        int idSizeInBit = this.imageManager.getGeometryManager().getIDSizeInBit();
        if (idSizeInBit != size) {
            GeometryManager[] geomManagers = this.vizFrame.getGeometryManagers();
            if (geomManagers != null) {
                for (int i = 0; i < geomManagers.length; ++i) {
                    geomManagers[i].setIDSizeInBit(size);
                }
            }
            this.idSpacePanel.resetSize();
            this.idSpacePanel.repaint();
        }
    }

    public void addNode(ID nodeID, MessagingAddress address) {
        this.idSpacePanel.addNode(nodeID, address);
        int lastNum = this.numOfNodes;
        this.numOfNodes = this.idSpacePanel.getNumOfNodes();
        if (this.numOfNodes != lastNum) {
            this.setNumOfNodeToGeometryManagers(this.numOfNodes);
        }
    }

    public void removeNode(ID nodeID) {
        this.idSpacePanel.removeNode(nodeID);
        int lastNum = this.numOfNodes;
        this.numOfNodes = this.idSpacePanel.getNumOfNodes();
        if (this.numOfNodes != lastNum) {
            this.setNumOfNodeToGeometryManagers(this.numOfNodes);
        }
    }

    private void setNumOfNodeToGeometryManagers(int num) {
        GeometryManager[] geomManagers = this.vizFrame.getGeometryManagers();
        if (geomManagers != null) {
            for (int i = 0; i < geomManagers.length; ++i) {
                geomManagers[i].setNumOfNodes(this.numOfNodes);
            }
        }
    }

    public void emphasizeNode(ID nodeID) {
        this.idSpacePanel.emphasizeNode(nodeID);
    }

    public void addMessage(ID src, ID dest, int tag) {
        this.idSpacePanel.addMessage(src, dest, tag);
    }

    public void addMark(ID id, int hint) {
        this.idSpacePanel.addMark(id, hint);
    }

    public void connectNodes(ID from, ID to, int colorHint) {
        this.idSpacePanel.connectNodes(from, to, colorHint);
    }

    public void disconnectNodes(ID from, ID to, int colorHint) {
        this.idSpacePanel.disconnectNodes(from, to, colorHint);
    }
}

