/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.profiler;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.profiler.DurationUnit;
import org.slf4j.profiler.ProfilerRegistry;
import org.slf4j.profiler.SpacePadder;
import org.slf4j.profiler.StopWatch;
import org.slf4j.profiler.TimeInstrument;
import org.slf4j.profiler.TimeInstrumentStatus;
import org.slf4j.profiler.Util;

public class Profiler
implements TimeInstrument {
    static final String PROFILER_MARKER_NAME = "PROFILER";
    static final int MIN_SW_NAME_LENGTH = 24;
    static final int MIN_SW_ELAPSED_TIME_NUMBER_LENGTH = 9;
    final String name;
    final StopWatch globalStopWatch;
    List<TimeInstrument> childTimeInstrumentList = new ArrayList<TimeInstrument>();
    ProfilerRegistry profilerRegistry;
    Logger logger;
    static String TOP_PROFILER_FIRST_PREFIX = "+";
    static String NESTED_PROFILER_FIRST_PREFIX = "|---+";
    static String TOTAL_ELAPSED = " Total        ";
    static String SUBTOTAL_ELAPSED = " Subtotal     ";
    static String ELAPSED_TIME = " elapsed time ";

    public Profiler(String name) {
        this.name = name;
        this.globalStopWatch = new StopWatch(name);
    }

    public String getName() {
        return this.name;
    }

    public ProfilerRegistry getProfilerRegistry() {
        return this.profilerRegistry;
    }

    public void registerWith(ProfilerRegistry profilerRegistry) {
        if (profilerRegistry == null) {
            return;
        }
        this.profilerRegistry = profilerRegistry;
        profilerRegistry.put(this);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void start(String name) {
        this.stopLastTimeInstrument();
        StopWatch childSW = new StopWatch(name);
        this.childTimeInstrumentList.add(childSW);
    }

    public Profiler startNested(String name) {
        this.stopLastTimeInstrument();
        Profiler nestedProfiler = new Profiler(name);
        nestedProfiler.registerWith(this.profilerRegistry);
        nestedProfiler.setLogger(this.logger);
        this.childTimeInstrumentList.add(nestedProfiler);
        return nestedProfiler;
    }

    TimeInstrument getLastTimeInstrument() {
        if (this.childTimeInstrumentList.size() > 0) {
            return this.childTimeInstrumentList.get(this.childTimeInstrumentList.size() - 1);
        }
        return null;
    }

    void stopLastTimeInstrument() {
        TimeInstrument last = this.getLastTimeInstrument();
        if (last != null) {
            last.stop();
        }
    }

    public long elapsedTime() {
        return this.globalStopWatch.elapsedTime();
    }

    public TimeInstrument stop() {
        this.stopLastTimeInstrument();
        this.globalStopWatch.stop();
        return this;
    }

    public TimeInstrumentStatus getStatus() {
        return this.globalStopWatch.status;
    }

    void sanityCheck() throws IllegalStateException {
        if (this.getStatus() != TimeInstrumentStatus.STOPPED) {
            throw new IllegalStateException("time instrument [" + this.getName() + " is not stopped");
        }
        long totalElapsed = this.globalStopWatch.elapsedTime();
        long childTotal = 0L;
        for (TimeInstrument ti : this.childTimeInstrumentList) {
            childTotal += ti.elapsedTime();
            if (ti.getStatus() != TimeInstrumentStatus.STOPPED) {
                throw new IllegalStateException("time instrument [" + ti.getName() + " is not stopped");
            }
            if (!(ti instanceof Profiler)) continue;
            Profiler nestedProfiler = (Profiler)ti;
            nestedProfiler.sanityCheck();
        }
        if (totalElapsed < childTotal) {
            throw new IllegalStateException("children have a higher accumulated elapsed time");
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        DurationUnit du = Util.selectDurationUnitForDisplay(this.globalStopWatch);
        return this.buildProfilerString(du, TOP_PROFILER_FIRST_PREFIX, TOTAL_ELAPSED, "");
    }

    public void log() {
        Marker profilerMarker = MarkerFactory.getMarker((String)PROFILER_MARKER_NAME);
        if (this.logger == null) {
            throw new NullPointerException("If you invoke the log() method, then you must associate a logger with this profiler.");
        }
        if (this.logger.isDebugEnabled(profilerMarker)) {
            DurationUnit du = Util.selectDurationUnitForDisplay(this.globalStopWatch);
            String r = this.buildProfilerString(du, TOP_PROFILER_FIRST_PREFIX, TOTAL_ELAPSED, "");
            this.logger.debug(profilerMarker, SpacePadder.LINE_SEP + r);
        }
    }

    private String buildProfilerString(DurationUnit du, String firstPrefix, String label, String indentation) {
        StringBuffer buf = new StringBuffer();
        buf.append(firstPrefix);
        buf.append(" Profiler [");
        buf.append(this.name);
        buf.append("]");
        buf.append(SpacePadder.LINE_SEP);
        for (TimeInstrument child : this.childTimeInstrumentList) {
            if (child instanceof StopWatch) {
                Profiler.buildStopWatchString(buf, du, ELAPSED_TIME, indentation, (StopWatch)child);
                continue;
            }
            if (!(child instanceof Profiler)) continue;
            Profiler profiler = (Profiler)child;
            String subString = profiler.buildProfilerString(du, NESTED_PROFILER_FIRST_PREFIX, SUBTOTAL_ELAPSED, indentation + "    ");
            buf.append(subString);
            Profiler.buildStopWatchString(buf, du, ELAPSED_TIME, indentation, profiler.globalStopWatch);
        }
        Profiler.buildStopWatchString(buf, du, label, indentation, this.globalStopWatch);
        return buf.toString();
    }

    private static void buildStopWatchString(StringBuffer buf, DurationUnit du, String prefix, String indentation, StopWatch sw) {
        buf.append(indentation);
        buf.append("|--");
        buf.append(prefix);
        SpacePadder.leftPad(buf, "[" + sw.getName() + "]", 24);
        buf.append(" ");
        String timeStr = Util.durationInDurationUnitsAsStr(sw.elapsedTime(), du);
        SpacePadder.leftPad(buf, timeStr, 9);
        buf.append(" ");
        Util.appendDurationUnitAsStr(buf, du);
        buf.append(SpacePadder.LINE_SEP);
    }
}

