/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DateType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimeType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimestampType;

public class SybaseGenDialect
extends StandardGenDialect {
    public SybaseGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("varbinary($l)"));
        this.sqlTypeMap.put(16, new BooleanType("bit"));
        this.sqlTypeMap.put(2004, new BlobType("image"));
        this.sqlTypeMap.put(2005, new ClobType("text"));
        this.sqlTypeMap.put(91, new DateType("datetime"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(8, new DoubleType("double precision"));
        this.sqlTypeMap.put(4, new IntegerType("int"));
        this.sqlTypeMap.put(92, new TimeType("datetime"));
        this.sqlTypeMap.put(93, new TimestampType("datetime"));
        this.columnTypeMap.put("binary", SybaseColumnType.BINARY);
        this.columnTypeMap.put("bit", SybaseColumnType.BIT);
        this.columnTypeMap.put("datetime", SybaseColumnType.DATETIME);
        this.columnTypeMap.put("decimal", SybaseColumnType.DECIMAL);
        this.columnTypeMap.put("image", SybaseColumnType.IMAGE);
        this.columnTypeMap.put("int", SybaseColumnType.INT);
        this.columnTypeMap.put("money", SybaseColumnType.MONEY);
        this.columnTypeMap.put("nchar", SybaseColumnType.NCHAR);
        this.columnTypeMap.put("ntext", SybaseColumnType.NTEXT);
        this.columnTypeMap.put("numeric", SybaseColumnType.NUMERIC);
        this.columnTypeMap.put("nvarchar", SybaseColumnType.NVARCHAR);
        this.columnTypeMap.put("smalldatetime", SybaseColumnType.SMALLDATETIME);
        this.columnTypeMap.put("smallmoney", SybaseColumnType.SMALLMONEY);
        this.columnTypeMap.put("text", SybaseColumnType.TEXT);
        this.columnTypeMap.put("varbinary", SybaseColumnType.VARBINARY);
    }

    public String getName() {
        return "sybase";
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public String getSqlBlockDelimiter() {
        return "go";
    }

    public String getIdentityColumnDefinition() {
        return "identity not null";
    }

    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new SybaseSqlBlockContext();
    }

    public boolean supportsIdentity() {
        return true;
    }

    public static class SybaseSqlBlockContext
    extends StandardGenDialect.StandardSqlBlockContext {
        protected SybaseSqlBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SybaseColumnType
    extends StandardGenDialect.StandardColumnType {
        private static SybaseColumnType BINARY = new SybaseColumnType("binary($l)", byte[].class);
        private static SybaseColumnType BIT = new SybaseColumnType("bit", Boolean.class);
        private static SybaseColumnType DATETIME = new SybaseColumnType("datetime", Timestamp.class);
        private static SybaseColumnType DECIMAL = new SybaseColumnType("decimal($p,$s)", BigDecimal.class);
        private static SybaseColumnType IMAGE = new SybaseColumnType("image", byte[].class, true);
        private static SybaseColumnType INT = new SybaseColumnType("int", Integer.class);
        private static SybaseColumnType MONEY = new SybaseColumnType("money", BigDecimal.class);
        private static SybaseColumnType NCHAR = new SybaseColumnType("nchar($l)", BigDecimal.class);
        private static SybaseColumnType NTEXT = new SybaseColumnType("ntext", BigDecimal.class);
        private static SybaseColumnType NUMERIC = new SybaseColumnType("numeric($p,$s)", BigDecimal.class);
        private static SybaseColumnType NVARCHAR = new SybaseColumnType("nvarchar($l)", String.class);
        private static SybaseColumnType SMALLDATETIME = new SybaseColumnType("smalldatetime", Timestamp.class);
        private static SybaseColumnType SMALLMONEY = new SybaseColumnType("smallmoney", BigDecimal.class);
        private static SybaseColumnType TEXT = new SybaseColumnType("text", String.class);
        private static SybaseColumnType VARBINARY = new SybaseColumnType("varbinary($l)", byte[].class);

        public SybaseColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public SybaseColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

