/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sql;

import java.io.File;
import java.sql.Statement;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.exception.SqlFailedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.sql.SqlFileReader;
import org.seasar.extension.jdbc.gen.internal.sql.SqlFileTokenizer;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlFileExecutor;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

public class SqlFileExecutorImpl
implements SqlFileExecutor {
    protected static Logger logger = Logger.getLogger(SqlFileExecutorImpl.class);
    protected GenDialect dialect;
    protected String sqlFileEncoding;
    protected char statementDelimiter;
    protected String blockDelimiter;

    public SqlFileExecutorImpl(GenDialect dialect, String sqlFileEncoding, char statementDelimiter, String blockDelimiter) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (sqlFileEncoding == null) {
            throw new NullPointerException("sqlFileEncoding");
        }
        this.sqlFileEncoding = sqlFileEncoding;
        this.statementDelimiter = statementDelimiter;
        this.blockDelimiter = blockDelimiter;
        this.dialect = dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SqlExecutionContext context, File sqlFile) {
        logger.log("DS2JDBCGen0006", new Object[]{sqlFile.getPath()});
        SqlFileReader reader = this.createSqlFileReader(sqlFile);
        try {
            String sql = reader.readSql();
            while (sql != null) {
                logger.debug((Object)sql);
                context.begin();
                try {
                    Statement statement = context.getStatement();
                    try {
                        statement.execute(sql);
                    }
                    catch (Exception e) {
                        context.addException((RuntimeException)((Object)new SqlFailedRuntimeException(e, sqlFile.getPath(), reader.getLineNumber(), sql)));
                    }
                }
                finally {
                    context.end();
                }
                sql = reader.readSql();
            }
        }
        finally {
            reader.close();
        }
        logger.log("DS2JDBCGen0007", new Object[]{sqlFile.getPath()});
    }

    public boolean isTarget(DatabaseDesc databaseDesc, File file) {
        if (databaseDesc == null || file == null) {
            return false;
        }
        return this.isTarget(databaseDesc, file, ".sql") || this.isTarget(databaseDesc, file, ".ddl");
    }

    protected boolean isTarget(DatabaseDesc databaseDesc, File file, String extension) {
        String tableName;
        if (!file.getName().endsWith(extension)) {
            return false;
        }
        return !databaseDesc.isFiltered() || databaseDesc.getTableDesc(tableName = StringUtil.trimSuffix((String)file.getName(), (String)extension)) != null;
    }

    protected SqlFileTokenizer createSqlFileTokenizer() {
        return new SqlFileTokenizer(this.statementDelimiter, this.blockDelimiter != null ? this.blockDelimiter : this.dialect.getSqlBlockDelimiter());
    }

    protected SqlFileReader createSqlFileReader(File sqlFile) {
        return new SqlFileReader(sqlFile, this.sqlFileEncoding, this.createSqlFileTokenizer(), this.dialect);
    }
}

