/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sql;

import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.seasar.extension.jdbc.gen.internal.exception.TransactionRuntimeException;
import org.seasar.extension.jdbc.gen.internal.sql.SqlExecutionContextImpl;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.framework.log.Logger;

public class SqlUnitExecutorImpl
implements SqlUnitExecutor {
    protected static Logger logger = Logger.getLogger(SqlUnitExecutorImpl.class);
    protected DataSource dataSource;
    protected UserTransaction userTransaction;
    protected boolean haltOnError;

    public SqlUnitExecutorImpl(DataSource dataSource, UserTransaction userTransaction, boolean haltOnError) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        this.dataSource = dataSource;
        this.userTransaction = userTransaction;
        this.haltOnError = haltOnError;
    }

    public void execute(SqlUnitExecutor.Callback callback) {
        boolean began = this.begin();
        boolean commit = true;
        try {
            this.executeInternal(callback);
        }
        catch (RuntimeException e) {
            commit = false;
            throw e;
        }
        finally {
            if (began) {
                this.end(commit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(SqlUnitExecutor.Callback callback) {
        SqlExecutionContext context = this.createSqlExecutionContext();
        try {
            callback.execute(context);
        }
        finally {
            context.destroy();
        }
    }

    protected boolean begin() {
        if (this.userTransaction == null) {
            return false;
        }
        if (!this.hasTransaction()) {
            try {
                this.userTransaction.begin();
            }
            catch (Exception e) {
                throw new TransactionRuntimeException(e);
            }
            return true;
        }
        return false;
    }

    protected boolean hasTransaction() {
        if (this.userTransaction == null) {
            return false;
        }
        int status = this.getTransactionStatus();
        return status != 6 && status != 5;
    }

    protected void end(boolean commit) {
        if (this.userTransaction == null) {
            return;
        }
        if (commit && this.getTransactionStatus() == 0) {
            try {
                this.userTransaction.commit();
            }
            catch (Exception e) {
                throw new TransactionRuntimeException(e);
            }
        }
        try {
            this.userTransaction.rollback();
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    protected int getTransactionStatus() {
        try {
            return this.userTransaction.getStatus();
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    protected SqlExecutionContext createSqlExecutionContext() {
        return new SqlExecutionContextImpl(this.dataSource, this.userTransaction == null, this.haltOnError);
    }
}

