/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.interceptor.InvocationContext;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
implements InvocationContext {
    protected MethodInvocation context;
    protected boolean lifecycleCallback;
    protected Map<String, Object> contextData = new HashMap<String, Object>();

    public InvocationContextImpl(MethodInvocation context) {
        this(context, false);
    }

    public InvocationContextImpl(MethodInvocation context, boolean lifecycleCallback) {
        this.context = context;
        this.lifecycleCallback = lifecycleCallback;
    }

    public Object getTarget() {
        return this.context.getThis();
    }

    public Method getMethod() {
        return this.context.getMethod();
    }

    public Object[] getParameters() {
        if (this.lifecycleCallback) {
            throw new IllegalStateException();
        }
        return this.context.getArguments();
    }

    public void setParameters(Object[] newParameters) {
        if (this.lifecycleCallback) {
            throw new IllegalStateException();
        }
        Object[] oldParameters = this.getParameters();
        if (newParameters.length != oldParameters.length) {
            throw new EJBException();
        }
        System.arraycopy(newParameters, 0, oldParameters, 0, newParameters.length);
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object proceed() throws Exception {
        try {
            return this.context.proceed();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            EJBException e = new EJBException();
            e.initCause(t);
            throw e;
        }
    }
}

