/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.MultiVersionIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class MultiVersionCursor
implements Cursor {
    private final MultiVersionIndex index;
    private final Session session;
    private final Cursor baseCursor;
    private final Cursor deltaCursor;
    private final Object sync;
    private SearchRow baseRow;
    private Row deltaRow;
    private boolean onBase;
    private boolean end;
    private boolean needNewDelta;
    private boolean needNewBase;

    MultiVersionCursor(Session session, MultiVersionIndex index, Cursor base, Cursor delta, Object sync) throws SQLException {
        this.session = session;
        this.index = index;
        this.baseCursor = base;
        this.deltaCursor = delta;
        this.sync = sync;
        this.needNewBase = true;
        this.needNewDelta = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNext(boolean base) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (base) {
                this.baseRow = this.baseCursor.next() ? this.baseCursor.getSearchRow() : null;
            } else {
                this.deltaRow = this.deltaCursor.next() ? this.deltaCursor.get() : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row get() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            return this.onBase ? this.baseCursor.get() : this.deltaCursor.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPos() {
        Object object = this.sync;
        synchronized (object) {
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            return this.onBase ? this.baseCursor.getPos() : this.deltaCursor.getPos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchRow getSearchRow() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            return this.onBase ? this.baseCursor.getSearchRow() : this.deltaCursor.getSearchRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            int compare;
            boolean isDeleted;
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            while (true) {
                if (this.needNewDelta) {
                    this.loadNext(false);
                    this.needNewDelta = false;
                }
                if (this.needNewBase) {
                    this.loadNext(true);
                    this.needNewBase = false;
                }
                if (this.deltaRow == null) {
                    if (this.baseRow == null) {
                        this.end = true;
                        return false;
                    }
                    this.onBase = true;
                    this.needNewBase = true;
                    return true;
                }
                int sessionId = this.deltaRow.getSessionId();
                boolean isThisSession = sessionId == this.session.getId();
                isDeleted = this.deltaRow.getDeleted();
                if (isThisSession && isDeleted) {
                    this.needNewDelta = true;
                    continue;
                }
                if (this.baseRow == null) {
                    if (isDeleted) {
                        if (isThisSession) {
                            this.end = true;
                            return false;
                        }
                        this.onBase = false;
                        this.needNewDelta = true;
                        return true;
                    }
                    throw Message.getInternalError();
                }
                compare = this.index.compareRows(this.deltaRow, this.baseRow);
                if (compare == 0) {
                    compare = this.index.compareKeys(this.deltaRow, this.baseRow);
                }
                if (compare != 0) break;
                if (isDeleted) {
                    if (isThisSession) {
                        throw Message.getInternalError();
                    }
                    throw Message.getInternalError();
                }
                if (isThisSession) {
                    this.onBase = false;
                    this.needNewBase = true;
                    this.needNewDelta = true;
                    return true;
                }
                this.needNewBase = true;
                this.needNewDelta = true;
            }
            if (compare > 0) {
                this.onBase = true;
                this.needNewBase = true;
                return true;
            }
            if (!isDeleted) {
                throw Message.getInternalError();
            }
            this.onBase = false;
            this.needNewDelta = true;
            return true;
        }
    }

    public boolean previous() {
        throw Message.getInternalError();
    }
}

