/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.dialect.StandardDialect;
import org.seasar.extension.jdbc.types.BytesType;
import org.seasar.extension.jdbc.types.SerializableType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreDialect
extends StandardDialect {
    protected static final String uniqueConstraintViolationCode = "23505";
    protected static final ValueType BLOB_TYPE = new BytesType((BytesType.Trait)new PostgreTrait());
    public static final ValueType SERIALIZABLE_BLOB_TYPE = new SerializableType((BytesType.Trait)new PostgreTrait());

    @Override
    public String getName() {
        return "postgre";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean needsParameterForResultSet() {
        return true;
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        buf.append(sql);
        if (limit > 0) {
            buf.append(" limit ");
            buf.append(limit);
        }
        if (offset > 0) {
            buf.append(" offset ");
            buf.append(offset);
        }
        return buf.toString();
    }

    @Override
    public ValueType getValueType(PropertyMeta propertyMeta) {
        ValueType valueType;
        Class<?> clazz = propertyMeta.getPropertyClass();
        if (propertyMeta.isLob()) {
            if (clazz == String.class) {
                return ValueTypes.STRING;
            }
            if (clazz == byte[].class) {
                return BLOB_TYPE;
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return SERIALIZABLE_BLOB_TYPE;
            }
        }
        if ((valueType = this.getValueTypeInternal(clazz)) != null) {
            return valueType;
        }
        return super.getValueType(propertyMeta);
    }

    @Override
    public ValueType getValueType(Class<?> clazz, boolean lob, TemporalType temporalType) {
        if (lob) {
            if (clazz == String.class) {
                return ValueTypes.STRING;
            }
            if (clazz == byte[].class) {
                return BLOB_TYPE;
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return SERIALIZABLE_BLOB_TYPE;
            }
        }
        return super.getValueType(clazz, lob, temporalType);
    }

    @Override
    protected ValueType getValueTypeInternal(Class<?> clazz) {
        if (List.class.isAssignableFrom(clazz)) {
            return ValueTypes.POSTGRE_RESULT_SET;
        }
        return null;
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public String getIdentitySelectString(String tableName, String columnName) {
        return new String(new StringBuilder(64).append("select currval('").append(tableName).append('_').append(columnName).append("_seq')"));
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "select nextval('" + sequenceName + "')";
    }

    @Override
    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return type == SelectForUpdateType.NORMAL;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        StringBuilder buf = new StringBuilder(100).append(" for update");
        if (aliases.length > 0) {
            buf.append(" of ");
            for (Pair<String, String> alias : aliases) {
                buf.append(alias.getFirst()).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        return new String(buf);
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean isUniqueConstraintViolation(Throwable t) {
        String state = this.getSQLState(t);
        return uniqueConstraintViolationCode.equals(state);
    }

    public static class BlobImpl
    implements Blob {
        protected byte[] bytes;

        public BlobImpl(byte[] bytes) {
            this.bytes = bytes;
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.bytes);
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            if (length == this.bytes.length) {
                return this.bytes;
            }
            byte[] result = new byte[length];
            System.arraycopy(this.bytes, 0, result, 0, length);
            return result;
        }

        public long length() throws SQLException {
            return this.bytes.length;
        }

        public long position(Blob pattern, long start) throws SQLException {
            throw new UnsupportedOperationException("position");
        }

        public long position(byte[] pattern, long start) throws SQLException {
            throw new UnsupportedOperationException("position");
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new UnsupportedOperationException("setBinaryStream");
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new UnsupportedOperationException("setBytes");
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new UnsupportedOperationException("setBytes");
        }

        public void truncate(long len) throws SQLException {
            throw new UnsupportedOperationException("truncate");
        }
    }

    public static class PostgreTrait
    implements BytesType.Trait {
        public int getSqlType() {
            return 2004;
        }

        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBlob(parameterIndex, new BlobImpl(bytes));
        }

        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBytes(parameterName, bytes);
        }

        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return BytesType.toBytes((Blob)rs.getBlob(columnIndex));
        }

        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return BytesType.toBytes((Blob)rs.getBlob(columnName));
        }

        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return BytesType.toBytes((Blob)cs.getBlob(columnIndex));
        }

        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return BytesType.toBytes((Blob)cs.getBlob(columnName));
        }
    }
}

