/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.Serializable;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.Tag;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingContext;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;

public class RoutingDriverMessageFactory {
    public static Message getPingMessage(IDAddressPair src) {
        int tag = Tag.PING.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getAckMessage(IDAddressPair src) {
        int tag = Tag.ACK.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getIteRouteNoneMessage(IDAddressPair src, ID[] target, int numClosestNodes, int numRootCandidates, RoutingContext[] cxt) {
        int tag = Tag.ITE_ROUTE_NONE.getNumber();
        return new Message(src, tag, target, Integer.valueOf(numClosestNodes), Integer.valueOf(numRootCandidates), cxt);
    }

    public static Message getIteRouteInvokeMessage(IDAddressPair src, ID[] target, int numClosestNodes, int numRootCandidates, RoutingContext[] cxt, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, IDAddressPair[] lastHop) {
        int tag = Tag.ITE_ROUTE_INVOKE.getNumber();
        return new Message(src, tag, new Serializable[]{target, Integer.valueOf(numClosestNodes), Integer.valueOf(numRootCandidates), cxt, filter, Integer.valueOf(callbackTag), callbackArgs, lastHop});
    }

    public static Message getIteRouteJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numClosestNodes, int numRootCandidates, RoutingContext[] cxt, IDAddressPair[] lastHop) {
        int tag = Tag.ITE_ROUTE_JOIN.getNumber();
        return new Message(src, tag, joiningNode, Integer.valueOf(numClosestNodes), Integer.valueOf(numRootCandidates), cxt, lastHop);
    }

    public static Message getIteAdjustLastHopReq(IDAddressPair src, ID[] target) {
        int tag = Tag.ITE_ADJUST_LAST_HOP_REQ.getNumber();
        return new Message(src, tag, new Serializable[]{target});
    }

    public static Message getIteAdjustLastHopRep(IDAddressPair src, IDAddressPair[][] adjustedLastHops) {
        int tag = Tag.ITE_ADJUST_LAST_HOP_REP.getNumber();
        return new Message(src, tag, new Serializable[]{adjustedLastHops});
    }

    public static Message getIteTerminateNoneMessage(IDAddressPair src, ID[] target, int numRootCandidates) {
        int tag = Tag.ITE_TERMINATE_NONE.getNumber();
        return new Message(src, tag, target, Integer.valueOf(numRootCandidates));
    }

    public static Message getIteTerminateInvokeMessage(IDAddressPair src, ID[] target, int numRootCandidates, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, IDAddressPair[] lastHop) {
        int tag = Tag.ITE_TERMINATE_INVOKE.getNumber();
        return new Message(src, tag, new Serializable[]{target, Integer.valueOf(numRootCandidates), filter, Integer.valueOf(callbackTag), callbackArgs, lastHop});
    }

    public static Message getIteTerminateJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numRootCandidates, IDAddressPair[] lastHop) {
        int tag = Tag.ITE_TERMINATE_JOIN.getNumber();
        return new Message(src, tag, joiningNode, Integer.valueOf(numRootCandidates), lastHop);
    }

    public static Message getIteReplyMessage(IDAddressPair src, IDAddressPair[][] closestNodes, IDAddressPair[][] rootCandidates, Serializable[] callbackResult) {
        int tag = Tag.ITE_REPLY.getNumber();
        return new Message(src, tag, new Serializable[]{closestNodes, rootCandidates, callbackResult});
    }

    public static Message getRecRouteNoneMessage(IDAddressPair src, ID[] target, int numRootCandidates, RoutingContext[] cxt, IDAddressPair initiator, int ttl, boolean adjustLastHop, RoutingHop[] route) {
        int tag = Tag.REC_ROUTE_NONE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numRootCandidates), cxt, initiator, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), route);
    }

    public static Message getRecRouteInvokeMessage(IDAddressPair src, ID[] target, int numRootCandidates, RoutingContext[] cxt, IDAddressPair initiator, int ttl, boolean adjustLastHop, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route) {
        int tag = Tag.REC_ROUTE_INVOKE.getNumber();
        return new Message(src, tag, new Serializable[]{null, target, Integer.valueOf(numRootCandidates), cxt, initiator, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), filter, Integer.valueOf(callbackTag), callbackArgs, route});
    }

    public static Message getRecRouteJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numRootCandidates, RoutingContext[] cxt, int ttl, boolean adjustLastHop, RoutingHop[] route) {
        int tag = Tag.REC_ROUTE_JOIN.getNumber();
        return new Message(src, tag, null, joiningNode, Integer.valueOf(numRootCandidates), cxt, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), route);
    }

    public static Message getRecTerminateNoneMessage(IDAddressPair src, ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, RoutingHop[] route) {
        int tag = Tag.REC_TERMINATE_NONE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numRootCandidates), initiator, Integer.valueOf(ttl), route);
    }

    public static Message getRecTerminateInvokeMessage(IDAddressPair src, ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route) {
        int tag = Tag.REC_TERMINATE_INVOKE.getNumber();
        return new Message(src, tag, new Serializable[]{null, target, Integer.valueOf(numRootCandidates), initiator, Integer.valueOf(ttl), filter, Integer.valueOf(callbackTag), callbackArgs, route});
    }

    public static Message getRecTerminateJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numRootCandidates, int ttl, RoutingHop[] route) {
        int tag = Tag.REC_TERMINATE_JOIN.getNumber();
        return new Message(src, tag, null, joiningNode, Integer.valueOf(numRootCandidates), Integer.valueOf(ttl), route);
    }

    public static Message getRecAckMessage(IDAddressPair src) {
        int tag = Tag.REC_ACK.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getRecResultMessage(IDAddressPair src, boolean succeed, ID[] target, RoutingResult[] routingRes, Serializable[] callbackResult) {
        int tag = Tag.REC_RESULT.getNumber();
        return new Message(src, tag, null, Boolean.valueOf(succeed), target, routingRes, callbackResult);
    }

    public static void setBlackList(Message msg, IDAddressPair[] blackList) {
        msg.setContents(0, (Serializable)blackList);
    }
}

