/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.emulator.action.InvocationTask;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvokeCommand
implements SchedulableCommand<EmulatorContext> {
    private static final String[] NAMES = new String[]{"invoke"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "invoke [<ID of app instace>]";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        String[] args = context.getArguments();
        PrintStream out = context.getOutputStream();
        EmulatorTask task = this.getEmulatorTask(context);
        if (task == null) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER && cxt.getVerboseInParsing()) {
            out.print("invoke");
            Class c = cxt.getCurrentClass();
            if (c != null) {
                out.print(": " + c.getName());
            }
            out.println(".");
        }
        ((TimerTask)task).run();
        return false;
    }

    @Override
    public EmulatorTask getEmulatorTask(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        String[] args = context.getArguments();
        int hostID = -1;
        if (args.length >= 1) {
            hostID = Integer.parseInt(args[0]);
        }
        return new InvocationTask(cxt, hostID, cxt.getCurrentClass(), cxt.getCurrentMainMethod(), cxt.getCurrentArguments(), cxt.getCurrentRelativePriority());
    }
}

