/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.IDSpacePanel;
import ow.tool.util.vizframework.ImageManager;
import ow.tool.util.vizframework.VisualizerUtil;

class VisualizerFrame
extends JFrame {
    private ImageManager imageManager;
    private IDSpacePanel idSpacePanel;
    private GeometryManager[] geometryManagers;
    private int geometryManagerIndex;
    private boolean imageToBeUpdated = true;

    public VisualizerFrame(ImageManager imageManager, int idSizeInBit) {
        this.imageManager = imageManager;
        this.setBackground(Color.WHITE);
        this.initComponents(idSizeInBit);
        this.setTitle("Overlay Visualizer");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    protected synchronized boolean imageToBeUpdated() {
        return this.imageToBeUpdated;
    }

    protected synchronized boolean imageToBeUpdated(boolean flag) {
        boolean old = this.imageToBeUpdated;
        this.imageToBeUpdated = flag;
        return old;
    }

    protected void paintComponent(Graphics g) {
    }

    private void initComponents(int idSizeInBit) {
        QuitAction quitAction = new QuitAction();
        ResetAction resetAction = new ResetAction();
        AboutAction aboutAction = new AboutAction();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(resetAction);
        fileMenu.add(quitAction);
        JMenu scaleMenu = new JMenu("Scale");
        JMenu scaleImageMenu = new JMenu("Scale Image");
        for (int i = 0; i < VisualizerUtil.SUPPORTED_SCALES.length; ++i) {
            String strScale = VisualizerUtil.SUPPORTED_SCALES[i];
            double scale = 1.0;
            try {
                scale = Double.parseDouble(strScale);
            }
            catch (Exception e) {
                // empty catch block
            }
            scaleMenu.add(new ScaleAction(this, strScale, scale));
            scaleImageMenu.add(new ScaleImageAction(this, strScale, scale));
        }
        JMenu idSpaceStyleMenu = new JMenu("ID Space Style");
        String packageName = VisualizerFrame.class.getPackage().getName() + ".";
        String geomMgrPkg = "geom";
        if (geomMgrPkg.length() > 0) {
            packageName = packageName + geomMgrPkg + ".";
        }
        int nGeometryManager = VisualizerUtil.GEOMETRY_MANAGERS.length;
        this.geometryManagers = new GeometryManager[nGeometryManager];
        for (int i = 0; i < nGeometryManager; ++i) {
            String cname = packageName + VisualizerUtil.GEOMETRY_MANAGERS[i][0];
            String entryname = VisualizerUtil.GEOMETRY_MANAGERS[i][1];
            try {
                Class<?> c = Class.forName(cname);
                this.geometryManagers[i] = (GeometryManager)c.newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate: " + cname);
                e.printStackTrace();
                System.exit(1);
            }
            idSpaceStyleMenu.add(new IDSpaceStyleAction(entryname, i, this));
        }
        this.geometryManagerIndex = 0;
        this.imageManager.setGeometryManager(this.geometryManagers[0]);
        JMenu lfMenu = new JMenu("Look & Feel");
        for (int i = 0; i < VisualizerUtil.LOOK_AND_FEELS.length; ++i) {
            String cname = VisualizerUtil.LOOK_AND_FEELS[i][0];
            String entryname = VisualizerUtil.LOOK_AND_FEELS[i][1];
            try {
                Class<?> c = Class.forName(cname);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            lfMenu.add(new LFAction(this, entryname, cname));
        }
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(aboutAction);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(scaleMenu);
        menubar.add(scaleImageMenu);
        menubar.add(idSpaceStyleMenu);
        menubar.add(lfMenu);
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar();
        JButton resetButton = toolbar.add(resetAction);
        JButton quitButton = toolbar.add(quitAction);
        contentPane.add((Component)toolbar, "North");
        resetButton.setFocusable(false);
        quitButton.setFocusable(false);
        this.idSpacePanel = new IDSpacePanel(this, this.imageManager);
        contentPane.add((Component)this.idSpacePanel, "West");
        for (GeometryManager geom : this.geometryManagers) {
            geom.setNodeOrderMap(this.idSpacePanel.getNodeOrderMap());
        }
        VisualizerFocusTraversalPolicy ftPolicy = new VisualizerFocusTraversalPolicy(this.idSpacePanel);
        this.setFocusTraversalPolicy(ftPolicy);
    }

    public IDSpacePanel getIDSpacePanel() {
        return this.idSpacePanel;
    }

    protected void setScale(double scale) {
        this.imageManager.setScale(scale);
        this.idSpacePanel.resetSize();
        this.pack();
        this.repaint();
    }

    protected void setImageScale(double scale) {
        this.imageManager.setImageScale(scale);
        this.idSpacePanel.resetSize();
        this.pack();
        this.repaint();
    }

    protected void setGeometryManager(int index) {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        GeometryManager nextGM = this.geometryManagers[index];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected void nextGeometryManager() {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        ++this.geometryManagerIndex;
        if (this.geometryManagerIndex >= this.geometryManagers.length) {
            this.geometryManagerIndex = 0;
        }
        GeometryManager nextGM = this.geometryManagers[this.geometryManagerIndex];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected void previousGeometryManager() {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        --this.geometryManagerIndex;
        if (this.geometryManagerIndex < 0) {
            this.geometryManagerIndex = this.geometryManagers.length - 1;
        }
        GeometryManager nextGM = this.geometryManagers[this.geometryManagerIndex];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected GeometryManager[] getGeometryManagers() {
        return this.geometryManagers;
    }

    public boolean isResizable() {
        return false;
    }

    private static class VisualizerFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final Component focused;

        VisualizerFocusTraversalPolicy(Component focused) {
            this.focused = focused;
        }

        public Component getInitialComponent(Window w) {
            return this.focused;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.focused;
        }

        public Component getFirstComponent(Container root) {
            return this.focused;
        }

        public Component getLastComponent(Container root) {
            return this.focused;
        }

        public Component getComponentAfter(Container root, Component c) {
            return this.focused;
        }

        public Component getComponentBefore(Container root, Component c) {
            return this.focused;
        }
    }

    private class LFAction
    extends AbstractAction {
        private Window windowToBeUpdated;
        private String classLF;

        LFAction(Window w, String entryname, String classLF) {
            super(entryname);
            this.windowToBeUpdated = w;
            this.classLF = classLF;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                UIManager.setLookAndFeel(this.classLF);
                SwingUtilities.updateComponentTreeUI(this.windowToBeUpdated);
                this.windowToBeUpdated.pack();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class IDSpaceStyleAction
    extends AbstractAction {
        int geometryManagerIndex;
        VisualizerFrame vizFrame;

        IDSpaceStyleAction(String entryname, int geometryManagerIndex, VisualizerFrame f) {
            super(entryname);
            this.geometryManagerIndex = geometryManagerIndex;
            this.vizFrame = f;
        }

        public void actionPerformed(ActionEvent ev) {
            this.vizFrame.setGeometryManager(this.geometryManagerIndex);
        }
    }

    public class ScaleImageAction
    extends AbstractAction {
        private VisualizerFrame vizframe;
        private double scale;

        ScaleImageAction(VisualizerFrame f, String entryname, double scale) {
            super(entryname);
            this.vizframe = f;
            this.scale = scale;
        }

        public void actionPerformed(ActionEvent ev) {
            this.vizframe.setImageScale(this.scale);
        }
    }

    public class ScaleAction
    extends AbstractAction {
        private VisualizerFrame vizframe;
        private double scale;

        ScaleAction(VisualizerFrame f, String entryname, double scale) {
            super(entryname);
            this.vizframe = f;
            this.scale = scale;
        }

        public void actionPerformed(ActionEvent ev) {
            this.vizframe.setScale(this.scale);
        }
    }

    private class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About Overlay Visualizer");
        }

        public void actionPerformed(ActionEvent e) {
            VisualizerUtil.showMessage(VisualizerFrame.this, "Overlay Visualizer for Overlay Weaver\nCopyright 2006-2007 Kazuyuki Shudo, National Institute of Advanced Industrial Science and Technology (AIST), and contributors");
        }
    }

    private class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset");
        }

        public void actionPerformed(ActionEvent e) {
            VisualizerFrame.this.imageManager.getGeometryManager().resetIncline();
            VisualizerFrame.this.idSpacePanel.resetLocation();
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("Quit");
        }

        public void actionPerformed(ActionEvent e) {
            VisualizerUtil.quit(VisualizerFrame.this, 0);
        }
    }
}

