<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.3 $
																																					-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="UTF-8" indent="yes" method="html"/>
  <xsl:param name="html.stylesheet">stylesheet.css</xsl:param>
  <xsl:param name="html.stylesheet.type">text/css</xsl:param>
  <xsl:param name="head.title">viewcollection.title</xsl:param>
  <xsl:param name="request.step">30</xsl:param>
  <xsl:param name="request.start">0</xsl:param>
  <xsl:param name="request.objectname"/>
  <xsl:param name="request.attribute"/>
  <xsl:param name="request.format"/>
  <xsl:param name="request.template"/>
  <xsl:include href="common.xsl"/>
  <!-- Main template -->
  <xsl:template match="/" name="main">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">mbean</xsl:with-param>
        </xsl:call-template>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td height="17"/>
            <td align="right" class="titre1" height="17" valign="middle">
              <img src="images/titres/tit_mbean_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr>
            <td>
              <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
            </td>
            <td align="left" bgcolor="#993399" nowrap="nowrap">
              <span class="Titre2">
                <font color="#FFFFFF">
                  <b>
                    <xsl:call-template name="str">
                      <xsl:with-param name="id">viewcollection.main.title.1</xsl:with-param>
                    </xsl:call-template>
                  </b>
                </font>
              </span>
            </td>
            <td>
              <img border="0" src="images/bkgd_onglet_tit.gif"/>
            </td>
            <td bgcolor="#660066" width="100%"/>
          </tr>
        </table>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr align="left" valign="top">
            <td bgcolor="#993399" class="Titre3black" width="160">
              <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                <b>
                  <xsl:call-template name="str">
                    <xsl:with-param name="id">viewcollection.main.index</xsl:with-param>
                  </xsl:call-template>
                </b>
              </font>
            </td>
            <td bgcolor="#993399" class="Titre3black" width="420">
              <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                <b>
                  <xsl:call-template name="str">
                    <xsl:with-param name="id">viewcollection.main.value</xsl:with-param>
                  </xsl:call-template>
                </b>
              </font>
            </td>
            <td bgcolor="#993399" class="Titre3black" width="420">
              <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                <b>
                  <xsl:call-template name="str">
                    <xsl:with-param name="id">viewcollection.main.valueclass</xsl:with-param>
                  </xsl:call-template>
                </b>
              </font>
            </td>
          </tr>
          <xsl:for-each select="MBean/Attribute/Collection/Element">
            <xsl:sort order="ascending" select="@index"/>
            <xsl:if test="position()&lt;($request.step+$request.start) and position()&gt;$request.start">
              <xsl:variable name="cellcolor">
                <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
                <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
              </xsl:variable>
              <tr bgcolor="{$cellcolor}">
                <td>
                  <xsl:value-of select="@index"/>
                </td>
                <td>
                  <xsl:value-of select="@element"/>
                </td>
                <td>
                  <xsl:value-of select="@elementclass"/>
                </td>
              </tr>
            </xsl:if>
          </xsl:for-each>
          <tr>
            <td colspan="3">
              <xsl:call-template name="str">
                <xsl:with-param name="id">viewcollection.main.title</xsl:with-param>
                <xsl:with-param name="p0">
                  <xsl:value-of select="MBean/@objectname"/>
                </xsl:with-param>
              </xsl:call-template>
            </td>
          </tr>
          <tr>
            <td colspan="3">
              <xsl:call-template name="str">
                <xsl:with-param name="id">viewcollection.main.viewcollectiontitle</xsl:with-param>
                <xsl:with-param name="p0">
                  <xsl:value-of select="MBean/Attribute/@classname"/>
                </xsl:with-param>
                <xsl:with-param name="p1">
                  <xsl:value-of select="MBean/Attribute/@name"/>
                </xsl:with-param>
              </xsl:call-template>
            </td>
          </tr>
          <xsl:variable name="url">getattribute?objectname=<xsl:call-template name="uri-encode">
              <xsl:with-param name="uri">
                <xsl:value-of select="$request.objectname"/>
              </xsl:with-param>
            </xsl:call-template>&amp;attribute=<xsl:value-of
              select="$request.attribute"/>&amp;format=collection&amp;template=viewcollection&amp;locale=<xsl:value-of select="$request.locale"/>
          </xsl:variable>
          <xsl:call-template name="aggregation-navigation">
            <xsl:with-param name="url" select="$url"/>
            <xsl:with-param name="total" select="count(MBean/Attribute/Collection/Element)"/>
            <xsl:with-param name="start" select="$request.start"/>
            <xsl:with-param name="step" select="$request.step"/>
            <xsl:with-param name="str.prefix">viewcollection.main</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="mbeanview">
            <xsl:with-param name="objectname" select="MBean/@objectname"/>
            <xsl:with-param name="colspan" select="3"/>
          </xsl:call-template>
        </table>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
