package org.positrium.chikarawo;

import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.TrayIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyTrayIcon extends TrayIcon implements
		GenkidamaStateChangeListener {
	public static Log logger = LogFactory.getLog(MyTrayIcon.class);

	public MyTrayIcon(String tooltip, PopupMenu popup) {
		super(Toolkit.getDefaultToolkit().getImage(
				"resource/genkidama_initial.png"), tooltip, popup);
	}

	@Override
	public void serverStateChanged(GenkidamaStateChangeEvent e) {
		switch (e.getStatus()) {
		case Gokuu.INITIAL:
			super.setImage(Toolkit.getDefaultToolkit().getImage(
					"resource/genkidama_initial.png"));
			logger.info("tray icon initial");
		case Gokuu.START:
			super.setImage(Toolkit.getDefaultToolkit().getImage(
					"resource/genkidama_begin.png"));
			logger.info("tray icon begin");
		}

	}
}
