package waket.remote;

import net.arnx.jsonic.JSON;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import waket.remote.dto.GlobalStatusDto;
import waket.remote.service.OnlineDataService;
import waket.remote.service.OnlineUsersService;

public class GlobalStatusJsoner extends AbstractJsoner {
	public static Log logger = LogFactory
		.getLog(GlobalStatusJsoner.class);

	private GlobalStatusDto globalStatusDto;
	private OnlineUsersService onlineUsersService;
	private OnlineDataService onlineDataService;

	@Override
	public void setup() {
		{
			SingletonS2ContainerFactory
				.init();

			// latest version は waket/remote/dto/dto.diconでDI済み
			S2Container container = SingletonS2ContainerFactory
				.getContainer();
			globalStatusDto = (GlobalStatusDto) container
				.getComponent("globalStatusDto");

			onlineUsersService = SingletonS2Container
				.getComponent("onlineUsersService");

			onlineDataService = SingletonS2Container
				.getComponent("onlineDataService");
		}

		globalStatusDto.onlineUsersCount = onlineUsersService
			.countOnlineUsers();
		globalStatusDto.sharedVideoCount = onlineDataService
			.countOnlineData();
	}

	@Override
	public void jsonize() {
		setDestfile("globalStatus");
		setJsonData(JSON
			.encode(
				globalStatusDto,
				true));

		// {
		// "onlines" : 5,
		// "entries" : 3200,
		// "latest" : "0.3.2"
		// }

	}
}
