/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaldataCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"localdata"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "localdata";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        ByteArray secret;
        Set<ValueInfo<String>> values;
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        StringBuilder sb = new StringBuilder();
        Set<ID> keySet = dht.getLocalKeys();
        if (keySet != null && !keySet.isEmpty()) {
            sb.append("Local directory (entries which this node has put):").append("\r\n");
            for (ID key : keySet) {
                values = dht.getLocalValues(key);
                sb.append("  key:   ").append(key).append("\r\n");
                if (values != null) {
                    for (ValueInfo<String> v : values) {
                        sb.append("  value: ").append(v.getValue());
                        secret = v.getHashedSecret();
                        if (secret != null) {
                            sb.append(" ").append(secret);
                        }
                        sb.append("\r\n");
                    }
                    continue;
                }
                sb.append("  value: (NULL)").append("\r\n");
            }
        }
        if (!(keySet = dht.getGlobalKeys()).isEmpty()) {
            sb.append("Global directory (local part of the DHT):").append("\r\n");
            for (ID key : keySet) {
                values = dht.getGlobalValues(key);
                sb.append("  key:   ").append(key).append("\r\n");
                if (values != null) {
                    for (ValueInfo<String> v : values) {
                        sb.append("  value: ").append(v.getValue()).append(" ").append(v.getTTL() / 1000L);
                        secret = v.getHashedSecret();
                        if (secret != null) {
                            sb.append(" ").append(secret);
                        }
                        sb.append("\r\n");
                    }
                    continue;
                }
                sb.append(" value: (NULL)").append("\r\n");
            }
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

