/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortBinding
extends TupleBinding<Short> {
    private static final int SHORT_SIZE = 2;

    @Override
    public Short entryToObject(TupleInput input) {
        return input.readShort();
    }

    @Override
    public void objectToEntry(Short object, TupleOutput output) {
        output.writeShort(object.shortValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Short object) {
        return ShortBinding.sizedOutput();
    }

    public static short entryToShort(DatabaseEntry entry) {
        return ShortBinding.entryToInput(entry).readShort();
    }

    public static void shortToEntry(short val, DatabaseEntry entry) {
        ShortBinding.outputToEntry(ShortBinding.sizedOutput().writeShort(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

