/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class Script
extends Tool {
    private void showUsage() {
        this.out.println("Allows converting a database to a SQL script.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -url <url>         The database URL\n" + " -user <user>       The user name\n" + " [-password <pwd>]  The password\n" + " [-script <file>]   The script file to run (default: backup.sql)\n" + " [-quiet]           Do not print progress information\n" + " [-options ...]     The list of options (only for H2 embedded mode)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new Script().run(args);
    }

    public void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String file = "backup.sql";
        String options1 = null;
        String options2 = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-script")) {
                file = args[++i];
                continue;
            }
            if (arg.equals("-options")) {
                StringBuffer buff1 = new StringBuffer();
                StringBuffer buff2 = new StringBuffer();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if (upper.startsWith("NO") || "DROP".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        if (url == null || user == null || file == null) {
            this.showUsage();
            return;
        }
        if (options1 != null) {
            this.processScript(url, user, password, file, options1, options2);
        } else {
            this.process(url, user, password, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            stat.execute(sql);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    public static void execute(String url, String user, String password, String fileName) throws SQLException {
        new Script().process(url, user, password, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(String url, String user, String password, String fileName) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        Writer fileWriter = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            fileWriter = FileUtils.openFileWriter(fileName, false);
            PrintWriter writer = new PrintWriter(fileWriter);
            ResultSet rs = stat.executeQuery("SCRIPT");
            while (rs.next()) {
                String s = rs.getString(1);
                writer.println(s);
            }
            writer.close();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            IOUtils.closeSilently(fileWriter);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
        IOUtils.closeSilently(fileWriter);
    }
}

