/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.util.S2ContainerUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.DisposableUtil;

public class HotdeployBehavior
extends S2ContainerBehavior.DefaultProvider {
    private static final Logger logger = Logger.getLogger(HotdeployBehavior.class);
    private ClassLoader originalClassLoader;
    private HotdeployClassLoader hotdeployClassLoader;
    private Map componentDefCache = new HashMap();
    private NamingConvention namingConvention;
    private ComponentCreator[] creators = new ComponentCreator[0];
    public static final String keep_BINDING = "bindingType=may";
    private boolean keep;

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public ComponentCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creators = creators;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
        if (this.hotdeployClassLoader != null) {
            this.finish();
        }
    }

    public void start() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (!this.keep || this.hotdeployClassLoader == null) {
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0108", null);
            }
            this.hotdeployClassLoader = new HotdeployClassLoader(this.originalClassLoader, this.namingConvention);
        }
        Thread.currentThread().setContextClassLoader(this.hotdeployClassLoader);
        S2ContainerImpl container = (S2ContainerImpl)SingletonS2ContainerFactory.getContainer();
        container.setClassLoader(this.hotdeployClassLoader);
    }

    public void stop() {
        if (!this.keep) {
            this.finish();
        }
        S2ContainerImpl container = (S2ContainerImpl)SingletonS2ContainerFactory.getContainer();
        container.setClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.originalClassLoader = null;
    }

    public void finish() {
        this.componentDefCache.clear();
        this.hotdeployClassLoader = null;
        DisposableUtil.dispose();
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0109", null);
        }
    }

    protected ComponentDef getComponentDef(S2Container container, Object key) {
        ComponentDef cd = super.getComponentDef(container, key);
        if (cd != null) {
            return cd;
        }
        if (container != container.getRoot()) {
            return null;
        }
        cd = this.getComponentDefFromCache(key);
        if (cd != null) {
            return cd;
        }
        if (key instanceof Class) {
            cd = this.createComponentDef((Class)key);
        } else if (key instanceof String) {
            cd = this.createComponentDef((String)key);
            if (cd != null && !key.equals(cd.getComponentName())) {
                logger.log("WSSR0011", new Object[]{key, cd.getComponentClass().getName(), cd.getComponentName()});
                cd = null;
            }
        } else {
            throw new IllegalArgumentException("key");
        }
        if (cd != null) {
            this.register(cd);
            S2ContainerUtil.putRegisterLog(cd);
            cd.init();
        }
        return cd;
    }

    protected ComponentDef getComponentDefFromCache(Object key) {
        return (ComponentDef)this.componentDefCache.get(key);
    }

    protected ComponentDef createComponentDef(Class componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected ComponentDef createComponentDef(String componentName) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentName);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected void register(ComponentDef componentDef) {
        componentDef.setContainer(SingletonS2ContainerFactory.getContainer());
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    protected void registerByClass(ComponentDef componentDef) {
        Class[] classes = S2ContainerUtil.getAssignableClasses(componentDef.getComponentClass());
        for (int i = 0; i < classes.length; ++i) {
            this.registerMap(classes[i], componentDef);
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        ComponentDef previousCd = (ComponentDef)this.componentDefCache.get(key);
        if (previousCd == null) {
            this.componentDefCache.put(key, componentDef);
        } else {
            ComponentDef tmrcd = S2ContainerImpl.createTooManyRegistration(key, previousCd, componentDef);
            this.componentDefCache.put(key, tmrcd);
        }
    }
}

