/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seasar.framework.aop.annotation.Interceptor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AspectDefBuilder;
import org.seasar.framework.container.factory.ComponentDefBuilder;
import org.seasar.framework.container.factory.ConstantAnnotationHandler;
import org.seasar.framework.container.factory.DestroyMethodDefBuilder;
import org.seasar.framework.container.factory.InitMethodDefBuilder;
import org.seasar.framework.container.factory.IntertypeDefBuilder;
import org.seasar.framework.container.factory.PropertyDefBuilder;
import org.seasar.framework.container.factory.aspect.AspectAnnotationAspectDefBuilder;
import org.seasar.framework.container.factory.aspect.EJB3AnnotationAspectDefBuilder;
import org.seasar.framework.container.factory.aspect.MetaAnnotationAspectDefBuilder;
import org.seasar.framework.container.factory.component.EJB3ComponentDefBuilder;
import org.seasar.framework.container.factory.component.PojoComponentDefBuilder;
import org.seasar.framework.container.factory.destroymethod.S2DestroyMethodDefBuilder;
import org.seasar.framework.container.factory.initmethod.EJB3InitMethodDefBuilder;
import org.seasar.framework.container.factory.initmethod.S2InitMethodDefBuilder;
import org.seasar.framework.container.factory.intertype.EJB3IntertypeDefBuilder;
import org.seasar.framework.container.factory.intertype.S2IntertypeDefBuilder;
import org.seasar.framework.container.factory.property.BindingPropertyDefBuilder;
import org.seasar.framework.container.factory.property.EJBPropertyDefBuilder;
import org.seasar.framework.container.factory.property.PersistenceContextPropertyDefBuilder;
import org.seasar.framework.container.factory.property.PersistenceUnitPropertyDefBuilder;
import org.seasar.framework.container.factory.property.ResourcePropertyDefBuilder;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class TigerAnnotationHandler
extends ConstantAnnotationHandler {
    protected static boolean initialized;
    protected static final boolean enableEJB3;
    protected static final boolean enableJPA;
    protected static final boolean enableCommonAnnotations;
    protected static final List<ComponentDefBuilder> componentDefBuilders;
    protected static final List<PropertyDefBuilder> propertyDefBuilders;
    protected static final List<AspectDefBuilder> aspectDefBuilders;
    protected static final List<IntertypeDefBuilder> intertypeDefBuilders;
    protected static final List<InitMethodDefBuilder> initMethodDefBuilders;
    protected static final List<DestroyMethodDefBuilder> destroyMethodDefBuilders;

    public static void initialize() {
        if (initialized) {
            return;
        }
        TigerAnnotationHandler.loadDefaultComponentDefBuilder();
        TigerAnnotationHandler.loadDefaultPropertyDefBuilder();
        TigerAnnotationHandler.loadDefaultAspectDefBuilder();
        TigerAnnotationHandler.loadDefaultIntertypeDefBuilder();
        TigerAnnotationHandler.loadDefaultInitMethodDefBuilder();
        TigerAnnotationHandler.loadDefaultDestroyMethodDefBuilder();
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                TigerAnnotationHandler.dispose();
            }
        });
        initialized = true;
    }

    public static void dispose() {
        TigerAnnotationHandler.clearComponentDefBuilder();
        TigerAnnotationHandler.clearPropertyDefBuilder();
        TigerAnnotationHandler.clearAspectDefBuilder();
        TigerAnnotationHandler.clearIntertypeDefBuilder();
        TigerAnnotationHandler.clearInitMethodDefBuilder();
        TigerAnnotationHandler.clearDestroyMethodDefBuilder();
        initialized = false;
    }

    public static void loadDefaultComponentDefBuilder() {
        if (enableEJB3) {
            componentDefBuilders.add(new EJB3ComponentDefBuilder());
        }
        componentDefBuilders.add(new PojoComponentDefBuilder());
    }

    public static void addComponentDefBuilder(ComponentDefBuilder builder) {
        componentDefBuilders.add(builder);
    }

    public static void removeComponentDefBuilder(ComponentDefBuilder builder) {
        componentDefBuilders.remove(builder);
    }

    public static void clearComponentDefBuilder() {
        componentDefBuilders.clear();
    }

    public static void loadDefaultPropertyDefBuilder() {
        TigerAnnotationHandler.clearPropertyDefBuilder();
        propertyDefBuilders.add(new BindingPropertyDefBuilder());
        if (enableEJB3) {
            propertyDefBuilders.add(new EJBPropertyDefBuilder());
        }
        if (enableJPA) {
            propertyDefBuilders.add(new PersistenceContextPropertyDefBuilder());
            propertyDefBuilders.add(new PersistenceUnitPropertyDefBuilder());
        }
        if (enableCommonAnnotations) {
            propertyDefBuilders.add(new ResourcePropertyDefBuilder());
        }
    }

    public static void addPropertyDefBuilder(PropertyDefBuilder builder) {
        propertyDefBuilders.add(builder);
    }

    public static void removePropertyDefBuilder(PropertyDefBuilder builder) {
        propertyDefBuilders.remove(builder);
    }

    public static void clearPropertyDefBuilder() {
        propertyDefBuilders.clear();
    }

    public static void loadDefaultAspectDefBuilder() {
        if (enableEJB3) {
            aspectDefBuilders.add(new EJB3AnnotationAspectDefBuilder());
        }
        aspectDefBuilders.add(new AspectAnnotationAspectDefBuilder());
        aspectDefBuilders.add(new MetaAnnotationAspectDefBuilder(Interceptor.class, "Interceptor"));
    }

    public static void addAspectDefBuilder(AspectDefBuilder builder) {
        aspectDefBuilders.add(builder);
    }

    public static void removeAspectDefBuilder(AspectDefBuilder builder) {
        aspectDefBuilders.remove(builder);
    }

    public static void clearAspectDefBuilder() {
        aspectDefBuilders.clear();
    }

    public static void loadDefaultIntertypeDefBuilder() {
        if (enableEJB3) {
            intertypeDefBuilders.add(new EJB3IntertypeDefBuilder());
        }
        intertypeDefBuilders.add(new S2IntertypeDefBuilder());
    }

    public static void addIntertypeDefBuilder(IntertypeDefBuilder builder) {
        intertypeDefBuilders.add(builder);
    }

    public static void removeIntertypeDefBuilder(IntertypeDefBuilder builder) {
        intertypeDefBuilders.remove(builder);
    }

    public static void clearIntertypeDefBuilder() {
        intertypeDefBuilders.clear();
    }

    public static void loadDefaultInitMethodDefBuilder() {
        if (enableEJB3) {
            initMethodDefBuilders.add(new EJB3InitMethodDefBuilder());
        }
        initMethodDefBuilders.add(new S2InitMethodDefBuilder());
    }

    public static void addInitMethodDefBuilder(InitMethodDefBuilder builder) {
        initMethodDefBuilders.add(builder);
    }

    public static void removeInitMethodDefBuilder(InitMethodDefBuilder builder) {
        initMethodDefBuilders.remove(builder);
    }

    public static void clearInitMethodDefBuilder() {
        initMethodDefBuilders.clear();
    }

    public static void loadDefaultDestroyMethodDefBuilder() {
        destroyMethodDefBuilders.add(new S2DestroyMethodDefBuilder());
    }

    public static void addDestroyMethodDefBuilder(DestroyMethodDefBuilder builder) {
        destroyMethodDefBuilders.add(builder);
    }

    public static void removeDestroyMethodDefBuilder(DestroyMethodDefBuilder builder) {
        destroyMethodDefBuilders.remove(builder);
    }

    public static void clearDestroyMethodDefBuilder() {
        destroyMethodDefBuilders.clear();
    }

    public ComponentDef createComponentDef(Class componentClass, InstanceDef defaultInstanceDef, AutoBindingDef defaultAutoBindingDef, boolean defaultExternalBinding) {
        TigerAnnotationHandler.initialize();
        for (ComponentDefBuilder builder : componentDefBuilders) {
            ComponentDef componentDef = builder.createComponentDef((AnnotationHandler)this, componentClass, defaultInstanceDef, defaultAutoBindingDef, defaultExternalBinding);
            if (componentDef == null) continue;
            return componentDef;
        }
        return super.createComponentDef(componentClass, defaultInstanceDef, defaultAutoBindingDef, defaultExternalBinding);
    }

    public PropertyDef createPropertyDef(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        if (propertyDesc.isWritable()) {
            for (PropertyDefBuilder builder : propertyDefBuilders) {
                PropertyDef propertyDef = builder.createPropertyDef((AnnotationHandler)this, beanDesc, propertyDesc);
                if (propertyDef == null) continue;
                return propertyDef;
            }
        }
        return super.createPropertyDef(beanDesc, propertyDesc);
    }

    public PropertyDef createPropertyDef(BeanDesc beanDesc, Field field) {
        for (PropertyDefBuilder builder : propertyDefBuilders) {
            PropertyDef propertyDef = builder.createPropertyDef((AnnotationHandler)this, beanDesc, field);
            if (propertyDef == null) continue;
            return propertyDef;
        }
        return super.createPropertyDef(beanDesc, field);
    }

    public void appendAspect(ComponentDef componentDef) {
        for (AspectDefBuilder builder : aspectDefBuilders) {
            builder.appendAspectDef((AnnotationHandler)this, componentDef);
        }
        super.appendAspect(componentDef);
    }

    public void appendInterType(ComponentDef componentDef) {
        for (IntertypeDefBuilder builder : intertypeDefBuilders) {
            builder.appendIntertypeDef((AnnotationHandler)this, componentDef);
        }
        super.appendInterType(componentDef);
    }

    public void appendInitMethod(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (InitMethodDefBuilder builder : initMethodDefBuilders) {
            builder.appendInitMethodDef((AnnotationHandler)this, componentDef);
        }
        super.appendInitMethod(componentDef);
    }

    public void appendDestroyMethod(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (DestroyMethodDefBuilder builder : destroyMethodDefBuilders) {
            builder.appendDestroyMethodDef((AnnotationHandler)this, componentDef);
        }
        super.appendDestroyMethod(componentDef);
    }

    static {
        boolean enable = false;
        try {
            Class.forName("javax.ejb.Stateless");
            Class.forName("javax.interceptor.Interceptors");
            enable = true;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        enableEJB3 = enable;
        enable = false;
        try {
            Class.forName("javax.persistence.PersistenceContext");
            enable = true;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        enableJPA = enable;
        enable = false;
        try {
            Class.forName("javax.annotation.Resource");
            enable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        enableCommonAnnotations = enable;
        componentDefBuilders = Collections.synchronizedList(new ArrayList());
        propertyDefBuilders = Collections.synchronizedList(new ArrayList());
        aspectDefBuilders = Collections.synchronizedList(new ArrayList());
        intertypeDefBuilders = Collections.synchronizedList(new ArrayList());
        initMethodDefBuilders = Collections.synchronizedList(new ArrayList());
        destroyMethodDefBuilders = Collections.synchronizedList(new ArrayList());
        TigerAnnotationHandler.initialize();
    }
}

