/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.Tracer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Evictor
extends DaemonThread {
    public static final String SOURCE_DAEMON = "daemon";
    public static final String SOURCE_MANUAL = "manual";
    public static final String SOURCE_CRITICAL = "critical";
    private static final boolean DEBUG = false;
    private MemoryBudget.Totals memBudgetTotals;
    private static final int MAX_BATCHES_PER_RUN = 100;
    private Level detailedTraceLevel;
    private volatile boolean active;
    private long currentRequiredEvictBytes;
    private int nodesPerScan;
    private long evictBytesSetting;
    private boolean evictByLruOnly;
    private boolean forcedYield;
    private int deadlockRetries;
    private NumberFormat formatter;
    private long nEvictPasses = 0L;
    private long nNodesSelected = 0L;
    private long nNodesSelectedThisRun;
    private long nNodesScanned = 0L;
    private long nNodesScannedThisRun;
    private long nNodesEvicted = 0L;
    private long nNodesEvictedThisRun;
    private long nRootNodesEvicted = 0L;
    private long nRootNodesEvictedThisRun;
    private long nBINsStripped = 0L;
    private long nBINsStrippedThisRun;
    EvictProfile evictProfile;
    private TestHook runnableHook;

    Evictor(EnvironmentImpl envImpl, String name) throws DatabaseException {
        super(0L, name, envImpl);
        this.memBudgetTotals = envImpl.getMemoryBudget().getTotals();
        DbConfigManager configManager = envImpl.getConfigManager();
        this.nodesPerScan = configManager.getInt(EnvironmentParams.EVICTOR_NODES_PER_SCAN);
        this.evictBytesSetting = configManager.getLong(EnvironmentParams.EVICTOR_EVICT_BYTES);
        this.evictByLruOnly = configManager.getBoolean(EnvironmentParams.EVICTOR_LRU_ONLY);
        this.forcedYield = configManager.getBoolean(EnvironmentParams.EVICTOR_FORCED_YIELD);
        this.deadlockRetries = configManager.getInt(EnvironmentParams.EVICTOR_RETRY);
        this.detailedTraceLevel = Tracer.parseLevel(envImpl, EnvironmentParams.JE_LOGGING_LEVEL_EVICTOR);
        this.evictProfile = new EvictProfile();
        this.formatter = NumberFormat.getNumberInstance();
        this.active = false;
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNEvictPasses(this.nEvictPasses);
        stat.setNNodesSelected(this.nNodesSelected);
        stat.setNNodesScanned(this.nNodesScanned);
        stat.setNNodesExplicitlyEvicted(this.nNodesEvicted);
        stat.setNRootNodesEvicted(this.nRootNodesEvicted);
        stat.setNBINsStripped(this.nBINsStripped);
        stat.setRequiredEvictBytes(this.currentRequiredEvictBytes);
        if (config.getClear()) {
            this.nEvictPasses = 0L;
            this.nNodesSelected = 0L;
            this.nNodesScanned = 0L;
            this.nNodesEvicted = 0L;
            this.nRootNodesEvicted = 0L;
            this.nBINsStripped = 0L;
        }
    }

    @Override
    protected long nDeadlockRetries() throws DatabaseException {
        return this.deadlockRetries;
    }

    public void alert() {
        if (!this.active) {
            this.wakeup();
        }
    }

    @Override
    public void onWakeup() throws DatabaseException {
        this.doEvict(SOURCE_DAEMON, false, true);
    }

    public void doEvict(String source) throws DatabaseException {
        this.doEvict(source, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doEvict(String source, boolean criticalEviction, boolean backgroundIO) throws DatabaseException {
        if (this.active) {
            return;
        }
        this.active = true;
        try {
            boolean progress = true;
            for (int nBatches = 0; progress && nBatches < 100 && (criticalEviction || !this.isShutdownRequested()) && this.isRunnable(source); ++nBatches) {
                if (this.evictBatch(source, backgroundIO, this.currentRequiredEvictBytes) != 0L) continue;
                progress = false;
            }
            Object var7_6 = null;
            this.active = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.active = false;
            throw throwable;
        }
    }

    public void doCriticalEviction(boolean backgroundIO) throws DatabaseException {
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long over = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        if (over > this.memBudgetTotals.getCriticalThreshold()) {
            this.doEvict(SOURCE_CRITICAL, true, backgroundIO);
        }
        if (this.forcedYield) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictBatch(String source, boolean backgroundIO, long requiredEvictBytes) throws DatabaseException {
        this.nNodesSelectedThisRun = 0L;
        this.nNodesEvictedThisRun = 0L;
        this.nRootNodesEvictedThisRun = 0L;
        this.nNodesScannedThisRun = 0L;
        this.nBINsStrippedThisRun = 0L;
        ++this.nEvictPasses;
        assert (this.evictProfile.clear());
        int nBatchSets = 0;
        boolean finished = false;
        long evictBytes = this.startBatch();
        int maxINsPerBatch = this.getMaxINsPerBatch();
        if (maxINsPerBatch == 0) {
            return evictBytes;
        }
        try {
            IN target;
            while (evictBytes < requiredEvictBytes && this.nNodesScannedThisRun <= (long)maxINsPerBatch && (target = this.selectIN(maxINsPerBatch)) != null) {
                Object var17_12;
                assert (this.evictProfile.count(target));
                DatabaseImpl targetDb = target.getDatabase();
                DbTree dbTree = targetDb.getDbEnvironment().getDbTree();
                DatabaseImpl refreshedDb = null;
                try {
                    refreshedDb = dbTree.getDb(targetDb.getId());
                    if (refreshedDb != null && !refreshedDb.isDeleted()) {
                        evictBytes = target.isDbRoot() ? (evictBytes += this.evictRoot(target, backgroundIO)) : (evictBytes += this.evictIN(target, backgroundIO));
                    } else if (targetDb.isDeleteFinished() && target.getInListResident()) {
                        String inInfo = " IN type=" + target.getLogType() + " id=" + target.getNodeId() + " not expected on INList";
                        String errMsg = refreshedDb == null ? inInfo : "Database " + refreshedDb.getDebugName() + " id=" + refreshedDb.getId() + " rootLsn=" + DbLsn.getNoFormatString(refreshedDb.getTree().getRootLsn()) + ' ' + inInfo;
                        throw new DatabaseException(errMsg);
                    }
                    var17_12 = null;
                    dbTree.releaseDb(refreshedDb);
                }
                catch (Throwable throwable) {
                    var17_12 = null;
                    dbTree.releaseDb(refreshedDb);
                    throw throwable;
                }
                ++nBatchSets;
            }
            finished = true;
            Object var19_16 = null;
            this.nNodesScanned += this.nNodesScannedThisRun;
            Logger logger = this.getLogger();
            if (logger != null && logger.isLoggable(this.detailedTraceLevel)) {
                logger.log(this.detailedTraceLevel, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " source=" + source + " requiredEvictBytes=" + this.formatter.format(requiredEvictBytes) + " evictBytes=" + this.formatter.format(evictBytes) + " inListSize=" + maxINsPerBatch + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nNodesEvicted=" + this.nNodesEvictedThisRun + " nRootNodesEvicted=" + this.nRootNodesEvictedThisRun + " nBINsStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
            }
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            this.nNodesScanned += this.nNodesScannedThisRun;
            Logger logger = this.getLogger();
            if (logger != null && logger.isLoggable(this.detailedTraceLevel)) {
                logger.log(this.detailedTraceLevel, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " source=" + source + " requiredEvictBytes=" + this.formatter.format(requiredEvictBytes) + " evictBytes=" + this.formatter.format(evictBytes) + " inListSize=" + maxINsPerBatch + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nNodesEvicted=" + this.nNodesEvictedThisRun + " nRootNodesEvicted=" + this.nRootNodesEvictedThisRun + " nBINsStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
            }
            throw throwable;
        }
        assert (LatchSupport.countLatchesHeld() == 0) : "latches held = " + LatchSupport.countLatchesHeld();
        return evictBytes;
    }

    private boolean isRunnable(String source) throws DatabaseException {
        Logger logger;
        boolean doRun;
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long overBudget = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        boolean bl = doRun = overBudget > 0L;
        if (doRun) {
            this.currentRequiredEvictBytes = overBudget + this.evictBytesSetting;
            if (currentUsage - this.currentRequiredEvictBytes < maxMem / 2L) {
                this.currentRequiredEvictBytes = overBudget + maxMem / 2L;
            }
        }
        if (this.runnableHook != null) {
            doRun = (Boolean)this.runnableHook.getHookValue();
            this.currentRequiredEvictBytes = maxMem;
        }
        if ((logger = this.getLogger()) != null && logger.isLoggable(this.detailedTraceLevel)) {
            Runtime r = Runtime.getRuntime();
            long totalBytes = r.totalMemory();
            long freeBytes = r.freeMemory();
            long usedBytes = r.totalMemory() - r.freeMemory();
            StringBuffer sb = new StringBuffer();
            sb.append(" source=").append(source);
            sb.append(" doRun=").append(doRun);
            sb.append(" JEusedBytes=").append(this.formatter.format(currentUsage));
            sb.append(" requiredEvict=").append(this.formatter.format(this.currentRequiredEvictBytes));
            sb.append(" JVMtotalBytes= ").append(this.formatter.format(totalBytes));
            sb.append(" JVMfreeBytes= ").append(this.formatter.format(freeBytes));
            sb.append(" JVMusedBytes= ").append(this.formatter.format(usedBytes));
            logger.log(this.detailedTraceLevel, sb.toString());
        }
        return doRun;
    }

    private IN selectIN(int maxNodesToIterate) throws DatabaseException {
        IN in;
        IN target = null;
        long targetGeneration = Long.MAX_VALUE;
        int targetLevel = Integer.MAX_VALUE;
        boolean targetDirty = true;
        int nCandidates = 0;
        int nIterated = 0;
        while (nIterated < maxNodesToIterate && nCandidates < this.nodesPerScan && (in = this.getNextIN()) != null) {
            int evictType;
            ++nIterated;
            ++this.nNodesScannedThisRun;
            DatabaseImpl db = in.getDatabase();
            if (db == null || db.isDeleted() || db.getDbEnvironment().isReadOnly() && in.getDirty() || (evictType = in.getEvictionType()) == 0) continue;
            if (this.evictByLruOnly) {
                if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    target = in;
                }
            } else {
                int level = this.normalizeLevel(in, evictType);
                if (targetLevel != level) {
                    if (targetLevel > level) {
                        targetLevel = level;
                        targetDirty = in.getDirty();
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                } else if (targetDirty != in.getDirty()) {
                    if (targetDirty) {
                        targetDirty = false;
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                } else if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    target = in;
                }
            }
            ++nCandidates;
        }
        if (target != null) {
            ++this.nNodesSelectedThisRun;
            ++this.nNodesSelected;
        }
        return target;
    }

    public int normalizeLevel(IN in, int evictType) {
        int level = in.getLevel() & 0xFFFF;
        if (level == 1 && evictType == 1) {
            level = 0;
        }
        return level;
    }

    private long evictRoot(final IN target, final boolean backgroundIO) throws DatabaseException {
        final DatabaseImpl db = target.getDatabase();
        final EnvironmentImpl envImpl = db.getDbEnvironment();
        final INList inList = envImpl.getInMemoryINs();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootEvictor
        implements WithRootLatched {
            boolean flushed = false;
            long evictBytes = 0L;

            RootEvictor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IN doWork(ChildReference root) throws DatabaseException {
                IN rootIN = (IN)root.fetchTarget(db, null);
                rootIN.latch(CacheMode.UNCHANGED);
                try {
                    boolean isDirty = rootIN.getDirty();
                    if (rootIN == target && rootIN.isDbRoot() && rootIN.isEvictable() && (!envImpl.isReadOnly() || !isDirty)) {
                        if (isDirty) {
                            long newLsn = rootIN.log(envImpl.getLogManager(), false, Evictor.this.isProvisionalRequired(rootIN), true, backgroundIO, null);
                            root.setLsn(newLsn);
                            this.flushed = true;
                        }
                        inList.remove(rootIN);
                        this.evictBytes = rootIN.getBudgetedMemorySize();
                        root.clearTarget();
                        Evictor.this.nRootNodesEvictedThisRun++;
                        Evictor.this.nRootNodesEvicted++;
                    }
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    rootIN.releaseLatch();
                    throw throwable;
                }
                rootIN.releaseLatch();
                return null;
            }
        }
        RootEvictor evictor = new RootEvictor();
        db.getTree().withRootLatchedExclusive(evictor);
        if (evictor.flushed) {
            envImpl.getDbTree().modifyDbRoot(db);
        }
        return evictor.evictBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long evictIN(IN target, boolean backgroundIO) throws DatabaseException {
        LocalUtilizationTracker localTracker;
        long evictedBytes;
        EnvironmentImpl envImpl;
        block9: {
            DatabaseImpl db = target.getDatabase();
            envImpl = db.getDbEnvironment();
            evictedBytes = 0L;
            localTracker = null;
            if (target.latchNoWait(CacheMode.UNCHANGED)) {
                boolean targetIsLatched = true;
                try {
                    if (target instanceof BIN) {
                        localTracker = new LocalUtilizationTracker(envImpl);
                        envImpl.lazyCompress(target, localTracker);
                        evictedBytes = ((BIN)target).evictLNs();
                        if (evictedBytes > 0L) {
                            ++this.nBINsStrippedThisRun;
                            ++this.nBINsStripped;
                        }
                    }
                    if (evictedBytes == 0L && target.isEvictable()) {
                        Tree tree = db.getTree();
                        targetIsLatched = false;
                        SearchResult result = tree.getParentINForChildIN(target, true, CacheMode.UNCHANGED);
                        if (result.exactParentFound) {
                            evictedBytes = this.evictIN(target, result.parent, result.index, backgroundIO);
                        }
                    }
                    Object var12_10 = null;
                    if (!targetIsLatched) break block9;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (targetIsLatched) {
                        target.releaseLatch();
                    }
                    throw throwable;
                }
                target.releaseLatch();
            }
        }
        if (localTracker != null) {
            envImpl.getUtilizationProfile().flushLocalTracker(localTracker);
        }
        return evictedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN child, IN parent, int index, boolean backgroundIO) throws DatabaseException {
        long evictBytes = 0L;
        try {
            assert (parent.isLatchOwnerForWrite());
            long oldGenerationCount = child.getGeneration();
            IN renewedChild = (IN)parent.getTarget(index);
            if (renewedChild != null && renewedChild.getGeneration() <= oldGenerationCount && renewedChild.latchNoWait(CacheMode.UNCHANGED)) {
                try {
                    if (renewedChild.isEvictable()) {
                        DatabaseImpl db = renewedChild.getDatabase();
                        EnvironmentImpl envImpl = db.getDbEnvironment();
                        long renewedChildLsn = -1L;
                        boolean newChildLsn = false;
                        if (renewedChild.getDirty()) {
                            if (!envImpl.isReadOnly()) {
                                boolean logProvisional = this.isProvisionalRequired(renewedChild);
                                renewedChildLsn = renewedChild.log(envImpl.getLogManager(), false, logProvisional, true, backgroundIO, parent);
                                newChildLsn = true;
                            }
                        } else {
                            renewedChildLsn = parent.getLsn(index);
                        }
                        if (renewedChildLsn != -1L) {
                            envImpl.getInMemoryINs().remove(renewedChild);
                            evictBytes = renewedChild.getBudgetedMemorySize();
                            if (newChildLsn) {
                                parent.updateNode(index, null, renewedChildLsn, null);
                            } else {
                                parent.updateNode(index, null, null);
                            }
                            ++this.nNodesEvictedThisRun;
                            ++this.nNodesEvicted;
                        }
                    }
                    Object var17_13 = null;
                }
                catch (Throwable throwable) {
                    Object var17_14 = null;
                    renewedChild.releaseLatch();
                    throw throwable;
                }
                renewedChild.releaseLatch();
                {
                }
            }
            Object var19_16 = null;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            parent.releaseLatch();
            throw throwable;
        }
        parent.releaseLatch();
        return evictBytes;
    }

    private boolean isProvisionalRequired(IN target) {
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        if (db.isDeferredWriteMode()) {
            return true;
        }
        Checkpointer ckpter = envImpl.getCheckpointer();
        return ckpter != null && target.getLevel() < ckpter.getHighestFlushLevel(db);
    }

    public void setRunnableHook(TestHook hook) {
        this.runnableHook = hook;
    }

    public abstract void clearEnv();

    public abstract void noteINListChange(int var1);

    public abstract void addEnvironment(EnvironmentImpl var1);

    public abstract void removeEnvironment(EnvironmentImpl var1);

    public abstract boolean checkEnvs(Set<EnvironmentImpl> var1);

    abstract Logger getLogger();

    abstract long startBatch() throws DatabaseException;

    abstract int getMaxINsPerBatch();

    abstract IN getNextIN();

    abstract Iterator<IN> getScanIterator();

    abstract void setScanIterator(Iterator<IN> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EvictProfile {
        private List<Long> candidates = new ArrayList<Long>();

        EvictProfile() {
        }

        public boolean count(IN target) {
            this.candidates.add(target.getNodeId());
            return true;
        }

        public List<Long> getCandidates() {
            return this.candidates;
        }

        public boolean clear() {
            this.candidates.clear();
            return true;
        }
    }
}

