/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.id;

import java.sql.Statement;
import java.util.concurrent.ConcurrentMap;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SqlLogger;
import org.seasar.extension.jdbc.id.AbstractIdGenerator;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.framework.util.tiger.CollectionsUtil;

public abstract class AbstractPreAllocateIdGenerator
extends AbstractIdGenerator {
    protected static String DEFAULT_ID_CONTEXT_KEY = IdContext.class.getName();
    protected final long allocationSize;
    protected ConcurrentMap<String, IdContext> idContextMap = CollectionsUtil.newConcurrentHashMap();

    public AbstractPreAllocateIdGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta, long allocationSize) {
        super(entityMeta, propertyMeta);
        this.allocationSize = allocationSize;
    }

    public boolean supportBatch(JdbcManagerImplementor jdbcManager) {
        return true;
    }

    public boolean useGetGeneratedKeys(JdbcManagerImplementor jdbcManager) {
        return false;
    }

    public boolean isInsertInto(JdbcManagerImplementor jdbcManager) {
        return true;
    }

    public Object preInsert(JdbcManagerImplementor jdbcManager, Object entity, SqlLogger sqlLogger) {
        long id = this.getIdContext(jdbcManager).getNextValue(jdbcManager, sqlLogger);
        this.setId(entity, id);
        return id;
    }

    public void postInsert(JdbcManagerImplementor jdbcManager, Object entity, Statement statement, SqlLogger sqlLogger) {
    }

    protected IdContext getIdContext(JdbcManagerImplementor jdbcManager) {
        String dsName = jdbcManager.getSelectableDataSourceName();
        String key = dsName != null ? dsName : DEFAULT_ID_CONTEXT_KEY;
        IdContext context = (IdContext)this.idContextMap.get(key);
        if (context != null) {
            return context;
        }
        return CollectionsUtil.putIfAbsent(this.idContextMap, key, new IdContext());
    }

    protected abstract long getNewInitialValue(JdbcManagerImplementor var1, SqlLogger var2);

    public class IdContext {
        protected long initialValue;
        protected long allocated = Long.MAX_VALUE;

        public synchronized long getNextValue(JdbcManagerImplementor jdbcManager, SqlLogger sqlLogger) {
            if (this.allocated < AbstractPreAllocateIdGenerator.this.allocationSize) {
                return this.initialValue + this.allocated++;
            }
            this.initialValue = AbstractPreAllocateIdGenerator.this.getNewInitialValue(jdbcManager, sqlLogger);
            this.allocated = 1L;
            return this.initialValue;
        }
    }
}

