/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatchedLogManager
extends LogManager {
    public LatchedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void serialLog(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.serialLogInternal(itemArray, context);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    @Override
    protected void flushInternal() throws LogException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.logBufferPool.writeBufferToFile(0);
        }
        catch (IOException e) {
            throw new LogException(e.getMessage());
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            TrackedFileSummary trackedFileSummary = this.getUnflushableTrackedSummaryInternal(file);
            return trackedFileSummary;
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrackedFile(TrackedFileSummary tfs) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.removeTrackedFileInternal(tfs);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteNodeInternal(lsn, type, size, nodeDb);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.transferToUtilizationTrackerInternal(localTracker);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteINs(List<Long> lsnList, DatabaseImpl nodeDb) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteINsInternal(lsnList, nodeDb);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteDb(DatabaseImpl db) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteDbInternal(db);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDbFileSummary(DatabaseImpl db, Long fileNum) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            boolean bl = this.removeDbFileSummaryInternal(db, fileNum);
            return bl;
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEndOfLogStat(EnvironmentStats stats) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.loadEndOfLogStatInternal(stats);
        }
        finally {
            this.logWriteLatch.release();
        }
    }
}

