/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.data.DumpFileTokenizer;
import org.seasar.extension.jdbc.gen.internal.exception.IllegalDumpColumnSizeRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.extension.jdbc.gen.internal.util.DumpUtil;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpFileReader {
    protected static final int BUF_SIZE = 8192;
    protected File dumpFile;
    protected String dumpFileEncoding;
    protected DumpFileTokenizer tokenizer;
    protected BufferedReader reader;
    protected char[] buf = new char[8192];
    protected DumpFileTokenizer.TokenType tokenType = DumpFileTokenizer.TokenType.END_OF_BUFFER;
    protected int lineNumber;
    protected int headerColumnSize;
    protected boolean endOfFile;

    public DumpFileReader(File dumpFile, String dumpFileEncoding, DumpFileTokenizer tokenizer) {
        if (dumpFile == null) {
            throw new NullPointerException("dumpFile");
        }
        if (dumpFileEncoding == null) {
            throw new NullPointerException("dumpFileEncoding");
        }
        if (tokenizer == null) {
            throw new NullPointerException("tokenizer");
        }
        this.dumpFile = dumpFile;
        this.dumpFileEncoding = dumpFileEncoding;
        this.tokenizer = tokenizer;
    }

    public List<String> readLine() {
        if (this.endOfFile) {
            return null;
        }
        try {
            ++this.lineNumber;
            List<String> valueList = this.readLineInternal();
            if (valueList == null) {
                --this.lineNumber;
                return null;
            }
            if (this.lineNumber == 1) {
                this.headerColumnSize = valueList.size();
            } else if (this.headerColumnSize != valueList.size()) {
                throw new IllegalDumpColumnSizeRuntimeException(this.dumpFile.getPath(), this.lineNumber, valueList.size(), this.headerColumnSize);
            }
            return valueList;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected List<String> readLineInternal() throws IOException {
        if (this.reader == null) {
            this.reader = this.createBufferedReader();
        }
        Line line = new Line();
        block6: while (true) {
            if (this.tokenType == DumpFileTokenizer.TokenType.END_OF_BUFFER) {
                int length = this.reader.read(this.buf);
                this.tokenizer.addChars(this.buf, length);
            }
            while (true) {
                this.tokenType = this.tokenizer.nextToken();
                String token = this.tokenizer.getToken();
                switch (this.tokenType) {
                    case VALUE: 
                    case NULL: {
                        line.add(token);
                        break;
                    }
                    case END_OF_BUFFER: {
                        continue block6;
                    }
                    case END_OF_LINE: {
                        return line.toList();
                    }
                    case END_OF_FILE: {
                        this.endOfFile = true;
                        if (!StringUtil.isEmpty((String)token)) {
                            line.add(token);
                        }
                        return line.toList();
                    }
                }
            }
            break;
        }
    }

    protected BufferedReader createBufferedReader() throws IOException {
        FileInputStream is = new FileInputStream(this.dumpFile);
        return new BufferedReader(new InputStreamReader((InputStream)is, this.dumpFileEncoding));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void close() {
        CloseableUtil.close(this.reader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Line {
        protected List<String> valueList = new ArrayList<String>(30);

        protected Line() {
        }

        public List<String> toList() {
            return !this.valueList.isEmpty() ? this.valueList : null;
        }

        public void add(String value) {
            this.valueList.add(DumpUtil.decode(value));
        }
    }
}

