/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.ColumnMeta;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.ColumnDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.exception.NullableUniqueNotSupportedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.exception.UnsupportedGenerationTypeRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.internal.util.PropertyMetaUtil;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.framework.util.StringUtil;

public class ColumnDescFactoryImpl
implements ColumnDescFactory {
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;

    public ColumnDescFactoryImpl(GenDialect dialect, ValueTypeProvider valueTypeProvider) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (valueTypeProvider == null) {
            throw new NullPointerException("valueTypeResolver");
        }
        this.dialect = dialect;
        this.valueTypeProvider = valueTypeProvider;
    }

    public ColumnDesc getColumnDesc(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        if (propertyMeta.isTransient() || propertyMeta.isRelationship()) {
            return null;
        }
        Column column = this.getColumn(propertyMeta);
        ColumnDesc columnDesc = new ColumnDesc();
        this.doName(entityMeta, propertyMeta, columnDesc, column);
        this.doComment(entityMeta, propertyMeta, columnDesc, column);
        this.doIdentity(entityMeta, propertyMeta, columnDesc, column);
        this.doDefinition(entityMeta, propertyMeta, columnDesc, column);
        this.doNullable(entityMeta, propertyMeta, columnDesc, column);
        this.doUnique(entityMeta, propertyMeta, columnDesc, column);
        this.doSqlType(entityMeta, propertyMeta, columnDesc, column);
        return columnDesc;
    }

    protected void doName(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        ColumnMeta columnMeta = propertyMeta.getColumnMeta();
        columnDesc.setName(columnMeta.getName());
    }

    protected void doComment(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        String comment = PropertyMetaUtil.getComment(propertyMeta);
        columnDesc.setComment(comment);
    }

    protected void doIdentity(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        GenerationType generationType = propertyMeta.getGenerationType();
        if (generationType == GenerationType.AUTO) {
            generationType = this.dialect.getDefaultGenerationType();
        }
        if (generationType == GenerationType.IDENTITY) {
            if (!this.dialect.supportsIdentity()) {
                throw new UnsupportedGenerationTypeRuntimeException(GenerationType.IDENTITY, entityMeta.getName(), propertyMeta.getName());
            }
            columnDesc.setIdentity(true);
        }
    }

    protected void doDefinition(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        SqlType type = this.dialect.getSqlType(this.valueTypeProvider, propertyMeta);
        String dataType = type.getDataType(column.length(), column.precision(), column.scale(), columnDesc.isIdentity());
        String definition = !StringUtil.isEmpty((String)column.columnDefinition()) ? (StringUtil.startsWithIgnoreCase((String)column.columnDefinition(), (String)"default ") ? dataType + " " + column.columnDefinition() : (StringUtil.startsWithIgnoreCase((String)column.columnDefinition(), (String)"check ") ? dataType + " " + column.columnDefinition() : column.columnDefinition())) : dataType;
        columnDesc.setDefinition(definition);
    }

    protected void doNullable(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        if (propertyMeta.isId()) {
            columnDesc.setNullable(false);
        } else if (column != AnnotationUtil.getDefaultColumn()) {
            columnDesc.setNullable(column.nullable());
        } else {
            Class<?> clazz = propertyMeta.getField().getType();
            columnDesc.setNullable(!clazz.isPrimitive());
        }
    }

    protected void doUnique(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        columnDesc.setUnique(column.unique());
        if (!this.dialect.supportsNullableUnique() && columnDesc.isNullable() && columnDesc.isUnique()) {
            throw new NullableUniqueNotSupportedRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
    }

    protected void doSqlType(EntityMeta entityMeta, PropertyMeta propertyMeta, ColumnDesc columnDesc, Column column) {
        SqlType sqlType = this.dialect.getSqlType(this.valueTypeProvider, propertyMeta);
        columnDesc.setSqlType(sqlType);
    }

    protected Column getColumn(PropertyMeta propertyMeta) {
        Field field = propertyMeta.getField();
        Column column = field.getAnnotation(Column.class);
        return column != null ? column : AnnotationUtil.getDefaultColumn();
    }
}

