/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class IntegerType
extends AbstractSqlType {
    public IntegerType() {
        this("integer");
    }

    public IntegerType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 4);
        } else {
            ps.setInt(index, IntegerConversionUtil.toPrimitiveInt((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Integer value = resultSet.getInt(index);
        return value != null ? StringConversionUtil.toString((Object)value) : null;
    }
}

